/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

public class PropNotMemberEnum
extends Propagator<IntVar> {
    private final TIntHashSet values;
    private final IntIterableBitSet vrms;

    public PropNotMemberEnum(IntVar var, int[] values) {
        super((Variable[])new IntVar[]{var}, PropagatorPriority.UNARY, false);
        this.values = new TIntHashSet(values);
        this.vrms = new IntIterableBitSet();
        int of = Integer.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= of) continue;
            of = values[i];
        }
        this.vrms.setOffset(of);
        this.vrms.addAll(values);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[0].removeValues(this.vrms, this);
        if (((IntVar[])this.vars)[0].hasEnumeratedDomain()) {
            this.setPassive();
        } else {
            int lb;
            int ub = ((IntVar[])this.vars)[0].getUB();
            for (lb = ((IntVar[])this.vars)[0].getLB(); lb <= ub && !this.values.contains(lb); ++lb) {
            }
            if (lb == ub) {
                this.setPassive();
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int ub = ((IntVar[])this.vars)[0].getUB();
        int nb = 0;
        int val = ((IntVar[])this.vars)[0].getLB();
        while (val <= ub) {
            if (!this.values.contains(val)) {
                ++nb;
            }
            val = ((IntVar[])this.vars)[0].nextValue(val);
        }
        if (nb == 0) {
            return ESat.FALSE;
        }
        if (nb == ((IntVar[])this.vars)[0].getDomainSize()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " outside " + Arrays.toString(this.values.toArray());
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        return ruleStore.addPropagatorActivationRule(this);
    }
}

