/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.util.ESat;

public class PropNotMemberBound
extends Propagator<IntVar> {
    private final int lb;
    private final int ub;

    public PropNotMemberBound(IntVar var, int lb, int ub) {
        super((Variable[])new IntVar[]{var}, PropagatorPriority.UNARY, false);
        this.lb = lb;
        this.ub = ub;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (((IntVar[])this.vars)[0].removeInterval(this.lb, this.ub, this) || ((IntVar[])this.vars)[0].getUB() < this.lb || ((IntVar[])this.vars)[0].getLB() > this.ub) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        int UB = ((IntVar[])this.vars)[0].getUB();
        int nb = 0;
        int val = ((IntVar[])this.vars)[0].getLB();
        while (val <= UB) {
            if (val < this.lb || val > this.ub) {
                ++nb;
            }
            val = ((IntVar[])this.vars)[0].nextValue(val);
        }
        if (nb == 0) {
            return ESat.FALSE;
        }
        if (nb == ((IntVar[])this.vars)[0].getDomainSize()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " outside [" + this.lb + "," + this.ub + "]";
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        return ruleStore.addPropagatorActivationRule(this);
    }
}

