/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropMemberBound
extends Propagator<IntVar> {
    private final int lb;
    private final int ub;

    public PropMemberBound(IntVar var, int lb, int ub) {
        super((Variable[])new IntVar[]{var}, PropagatorPriority.UNARY, false);
        this.lb = lb;
        this.ub = ub;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[0].updateBounds(this.lb, this.ub, this);
        if (this.lb <= ((IntVar[])this.vars)[0].getLB() && this.ub >= ((IntVar[])this.vars)[0].getUB()) {
            this.setPassive();
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].getLB() >= this.lb && ((IntVar[])this.vars)[0].getUB() <= this.ub) {
            return ESat.TRUE;
        }
        if (((IntVar[])this.vars)[0].nextValue(this.lb - 1) > this.ub) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " in [" + this.lb + "," + this.ub + "]";
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        return ruleStore.addPropagatorActivationRule(this);
    }
}

