/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

public class PropXplusYeqZ
extends Propagator<IntVar> {
    private int x = 0;
    private int y = 1;
    private int z = 2;
    private boolean allbounded = false;
    private IntIterableRangeSet r1;
    private IntIterableRangeSet r2;
    private IntIterableRangeSet r3;

    public PropXplusYeqZ(IntVar X, IntVar Y, IntVar Z) {
        super((Variable[])new IntVar[]{X, Y, Z}, PropagatorPriority.TERNARY, false);
        this.allbounded = !this.model.getSettings().enableACOnTernarySum() || !X.hasEnumeratedDomain() & !Y.hasEnumeratedDomain() & !Z.hasEnumeratedDomain();
        this.r1 = new IntIterableRangeSet();
        this.r2 = new IntIterableRangeSet();
        this.r3 = new IntIterableRangeSet();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        do {
            boolean loop = this.filterPlus(this.z, this.x, this.y);
            loop |= this.filterMinus(this.x, this.z, this.y);
            loop |= this.filterMinus(this.y, this.z, this.x);
        } while (loop &= this.allbounded);
    }

    private boolean filterPlus(int vr, int v1, int v2) throws ContradictionException {
        int lb = ((IntVar[])this.vars)[v1].getLB() + ((IntVar[])this.vars)[v2].getLB();
        int ub = ((IntVar[])this.vars)[v1].getUB() + ((IntVar[])this.vars)[v2].getUB();
        boolean change = ((IntVar[])this.vars)[vr].updateBounds(lb, ub, this);
        if (!this.allbounded) {
            IntIterableSetUtils.copyIn(((IntVar[])this.vars)[v1], this.r1);
            IntIterableSetUtils.copyIn(((IntVar[])this.vars)[v2], this.r2);
            IntIterableSetUtils.plus(this.r3, this.r1, this.r2);
            change |= ((IntVar[])this.vars)[vr].removeAllValuesBut(this.r3, this);
        }
        return change;
    }

    private boolean filterMinus(int vr, int v1, int v2) throws ContradictionException {
        int lb = ((IntVar[])this.vars)[v1].getLB() - ((IntVar[])this.vars)[v2].getUB();
        int ub = ((IntVar[])this.vars)[v1].getUB() - ((IntVar[])this.vars)[v2].getLB();
        boolean change = ((IntVar[])this.vars)[vr].updateBounds(lb, ub, this);
        if (!this.allbounded) {
            IntIterableSetUtils.copyIn(((IntVar[])this.vars)[v1], this.r1);
            IntIterableSetUtils.copyIn(((IntVar[])this.vars)[v2], this.r2);
            IntIterableSetUtils.minus(this.r3, this.r1, this.r2);
            change |= ((IntVar[])this.vars)[vr].removeAllValuesBut(this.r3, this);
        }
        return change;
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(((IntVar[])this.vars)[this.x].getValue() + ((IntVar[])this.vars)[this.y].getValue() == ((IntVar[])this.vars)[this.z].getValue());
        }
        return ESat.UNDEFINED;
    }
}

