/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.MathUtils;

public class PropTimesNaive
extends Propagator<IntVar> {
    protected static final int MAX = 0x7FFFFFFE;
    protected static final int MIN = -2147483647;
    private IntVar v0;
    private IntVar v1;
    private IntVar v2;

    public PropTimesNaive(IntVar v1, IntVar v2, IntVar result) {
        super((Variable[])new IntVar[]{v1, v2, result}, PropagatorPriority.TERNARY, false);
        this.v0 = ((IntVar[])this.vars)[0];
        this.v1 = ((IntVar[])this.vars)[1];
        this.v2 = ((IntVar[])this.vars)[2];
    }

    @Override
    public final int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public final void propagate(int evtmask) throws ContradictionException {
        for (boolean hasChanged = true; hasChanged; hasChanged |= this.mul(this.v2, this.v0.getLB(), this.v0.getUB(), this.v1.getLB(), this.v1.getUB())) {
            hasChanged = this.div(this.v0, this.v2.getLB(), this.v2.getUB(), this.v1.getLB(), this.v1.getUB());
            hasChanged |= this.div(this.v1, this.v2.getLB(), this.v2.getUB(), this.v0.getLB(), this.v0.getUB());
        }
        if (this.v2.isInstantiatedTo(0) && (this.v0.isInstantiatedTo(0) || this.v1.isInstantiatedTo(1))) {
            this.setPassive();
        }
    }

    @Override
    public final ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(this.v0.getValue() * this.v1.getValue() == this.v2.getValue());
        }
        return ESat.UNDEFINED;
    }

    private boolean div(IntVar var, int a, int b, int c, int d) throws ContradictionException {
        if (a <= 0 && b >= 0 && c <= 0 && d >= 0) {
            int min = -2147483647;
            int max = 0x7FFFFFFE;
            return var.updateLowerBound(min, this) | var.updateUpperBound(max, this);
        }
        if (c != 0 || d != 0 || a <= 0 && b >= 0) {
            int max;
            if (c < 0 && d > 0 && (a > 0 || b < 0)) {
                int max2 = Math.max(Math.abs(a), Math.abs(b));
                int min = -max2;
                return var.updateLowerBound(min, this) | var.updateUpperBound(max2, this);
            }
            if (c == 0 && d != 0 && (a > 0 || b < 0)) {
                return this.div(var, a, b, 1, d);
            }
            if (c != 0 && d == 0 && (a > 0 || b < 0)) {
                return this.div(var, a, b, c, -1);
            }
            float ac = (float)a / (float)c;
            float ad = (float)a / (float)d;
            float bc = (float)b / (float)c;
            float bd = (float)b / (float)d;
            float low = Math.min(Math.min(ac, ad), Math.min(bc, bd));
            float high = Math.max(Math.max(ac, ad), Math.max(bc, bd));
            int min = (int)Math.round(Math.ceil(low));
            if (min > (max = (int)Math.round(Math.floor(high)))) {
                this.fails();
            }
            return var.updateLowerBound(min, this) | var.updateUpperBound(max, this);
        }
        this.fails();
        return false;
    }

    private boolean mul(IntVar var, int a, int b, int c, int d) throws ContradictionException {
        int min = Math.min(Math.min(MathUtils.safeMultiply(a, c), MathUtils.safeMultiply(a, d)), Math.min(MathUtils.safeMultiply(b, c), MathUtils.safeMultiply(b, d)));
        int max = Math.max(Math.max(MathUtils.safeMultiply(a, c), MathUtils.safeMultiply(a, d)), Math.max(MathUtils.safeMultiply(b, c), MathUtils.safeMultiply(b, d)));
        return var.updateLowerBound(min, this) | var.updateUpperBound(max, this);
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        for (int i = 0; i < 3; ++i) {
            if (var == ((IntVar[])this.vars)[i]) continue;
            newrules |= ruleStore.addBoundsRule(((IntVar[])this.vars)[i]);
        }
        return newrules;
    }
}

