/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropMinBC
extends Propagator<IntVar> {
    private IntVar BST;
    private IntVar v1;
    private IntVar v2;

    public PropMinBC(IntVar X, IntVar Y, IntVar Z) {
        super((Variable[])new IntVar[]{X, Y, Z}, PropagatorPriority.TERNARY, false);
        this.BST = ((IntVar[])this.vars)[0];
        this.v1 = ((IntVar[])this.vars)[1];
        this.v2 = ((IntVar[])this.vars)[2];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter();
    }

    private void filter() throws ContradictionException {
        int c = 0;
        c += ((IntVar[])this.vars)[0].isInstantiated() ? 1 : 0;
        c += ((IntVar[])this.vars)[1].isInstantiated() ? 2 : 0;
        switch (c += ((IntVar[])this.vars)[2].isInstantiated() ? 4 : 0) {
            case 6: 
            case 7: {
                ((IntVar[])this.vars)[0].instantiateTo(Math.min(((IntVar[])this.vars)[1].getValue(), ((IntVar[])this.vars)[2].getValue()), this);
                break;
            }
            case 5: {
                int best = ((IntVar[])this.vars)[0].getValue();
                int val2 = ((IntVar[])this.vars)[2].getValue();
                if (best < val2) {
                    ((IntVar[])this.vars)[1].instantiateTo(best, this);
                    break;
                }
                if (best > val2) {
                    this.fails();
                    break;
                }
                ((IntVar[])this.vars)[1].updateLowerBound(best, this);
                break;
            }
            case 4: {
                int val = ((IntVar[])this.vars)[2].getValue();
                if (val < ((IntVar[])this.vars)[1].getLB()) {
                    if (!((IntVar[])this.vars)[0].instantiateTo(val, this)) break;
                    this.setPassive();
                    break;
                }
                this._filter();
                break;
            }
            case 3: {
                int best = ((IntVar[])this.vars)[0].getValue();
                int val1 = ((IntVar[])this.vars)[1].getValue();
                if (best < val1) {
                    ((IntVar[])this.vars)[2].instantiateTo(best, this);
                    break;
                }
                if (best > val1) {
                    this.fails();
                    break;
                }
                ((IntVar[])this.vars)[2].updateLowerBound(best, this);
                break;
            }
            case 2: {
                int val = ((IntVar[])this.vars)[1].getValue();
                if (val < ((IntVar[])this.vars)[2].getLB()) {
                    if (!((IntVar[])this.vars)[0].instantiateTo(val, this)) break;
                    this.setPassive();
                    break;
                }
                this._filter();
                break;
            }
            case 1: {
                int best = ((IntVar[])this.vars)[0].getValue();
                if (!((IntVar[])this.vars)[1].contains(best) && !((IntVar[])this.vars)[2].contains(best)) {
                    this.fails();
                }
                if (((IntVar[])this.vars)[1].getLB() > best) {
                    if (!((IntVar[])this.vars)[2].instantiateTo(best, this)) break;
                    this.setPassive();
                    break;
                }
                if (((IntVar[])this.vars)[2].getLB() > best) {
                    if (!((IntVar[])this.vars)[1].instantiateTo(best, this)) break;
                    this.setPassive();
                    break;
                }
                if (!(((IntVar[])this.vars)[1].updateLowerBound(best, this) | ((IntVar[])this.vars)[2].updateLowerBound(best, this))) break;
                this.filter();
                break;
            }
            case 0: {
                this._filter();
                break;
            }
            default: {
                throw new SolverException("Unexpected mask " + c);
            }
        }
    }

    private void _filter() throws ContradictionException {
        boolean change;
        do {
            change = ((IntVar[])this.vars)[0].updateLowerBound(Math.min(((IntVar[])this.vars)[1].getLB(), ((IntVar[])this.vars)[2].getLB()), this);
            change |= ((IntVar[])this.vars)[0].updateUpperBound(Math.min(((IntVar[])this.vars)[1].getUB(), ((IntVar[])this.vars)[2].getUB()), this);
            change |= ((IntVar[])this.vars)[1].updateLowerBound(((IntVar[])this.vars)[0].getLB(), this);
            change |= ((IntVar[])this.vars)[2].updateLowerBound(((IntVar[])this.vars)[0].getLB(), this);
            if (((IntVar[])this.vars)[2].getLB() > ((IntVar[])this.vars)[0].getUB()) {
                change |= ((IntVar[])this.vars)[1].updateUpperBound(((IntVar[])this.vars)[0].getUB(), this);
            }
            if (((IntVar[])this.vars)[1].getLB() <= ((IntVar[])this.vars)[0].getUB()) continue;
            change |= ((IntVar[])this.vars)[2].updateUpperBound(((IntVar[])this.vars)[0].getUB(), this);
        } while (change);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.BST.getValue() != Math.min(this.v1.getValue(), this.v2.getValue())) {
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.BST.toString() + ".MIN(" + this.v1.toString() + "," + this.v2.toString() + ")";
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        if (var == null) {
            super.why(ruleStore, null, evt, value);
        } else if (var == ((IntVar[])this.vars)[0]) {
            if (IntEventType.isInstantiate(evt.getMask())) {
                if (((IntVar[])this.vars)[1].isInstantiated()) {
                    newrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[1]);
                    newrules |= ruleStore.addLowerBoundRule(((IntVar[])this.vars)[2]);
                }
                if (((IntVar[])this.vars)[2].isInstantiated()) {
                    newrules |= ruleStore.addLowerBoundRule(((IntVar[])this.vars)[1]);
                    newrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[2]);
                }
            } else {
                if (IntEventType.isInclow(evt.getMask())) {
                    newrules |= ruleStore.addLowerBoundRule(((IntVar[])this.vars)[1]);
                    newrules |= ruleStore.addLowerBoundRule(((IntVar[])this.vars)[2]);
                }
                if (IntEventType.isDecupp(evt.getMask())) {
                    newrules |= ruleStore.addUpperBoundRule(((IntVar[])this.vars)[1]);
                    newrules |= ruleStore.addUpperBoundRule(((IntVar[])this.vars)[2]);
                }
            }
        } else {
            int i;
            int n = i = var == ((IntVar[])this.vars)[1] ? 2 : 1;
            if (IntEventType.isInstantiate(evt.getMask())) {
                newrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[0]);
                newrules = ((IntVar[])this.vars)[i].isInstantiated() ? (newrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[i])) : (newrules |= ruleStore.addLowerBoundRule(((IntVar[])this.vars)[i]));
            } else {
                if (IntEventType.isInclow(evt.getMask())) {
                    newrules = ((IntVar[])this.vars)[0].isInstantiated() ? (newrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[0])) : (newrules |= ruleStore.addLowerBoundRule(((IntVar[])this.vars)[0]));
                    newrules = ((IntVar[])this.vars)[i].isInstantiated() ? (newrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[i])) : (newrules |= ruleStore.addLowerBoundRule(((IntVar[])this.vars)[i]));
                }
                if (IntEventType.isDecupp(evt.getMask())) {
                    newrules |= ruleStore.addLowerBoundRule(((IntVar[])this.vars)[0]);
                    newrules |= ruleStore.addLowerBoundRule(((IntVar[])this.vars)[i]);
                }
            }
        }
        return newrules;
    }
}

