/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public final class PropDistanceXYZ
extends Propagator<IntVar> {
    private Operator operator;

    public PropDistanceXYZ(IntVar[] vars, Operator op) {
        super((Variable[])vars, PropagatorPriority.TERNARY, true);
        this.operator = op;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filterFixPoint();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.filterFixPoint();
    }

    public void filterFixPoint() throws ContradictionException {
        boolean change = true;
        while (change) {
            if (this.operator == Operator.EQ) {
                change = this.filterFromXYtoLBZ();
                change |= this.filterFromXYtoUBZ();
                change |= this.filterEQFromXZToY();
                change |= this.filterEQFromYZToX();
                continue;
            }
            if (this.operator == Operator.LT) {
                change = this.filterFromXYtoLBZ();
                change |= this.filterLTFromXZtoY();
                change |= this.filterLTFromYZtoX();
                continue;
            }
            if (this.operator != Operator.GT) continue;
            change = this.filterFromXYtoUBZ();
            change |= this.filterGTFromXZtoY();
            change |= this.filterGTFromYZtoX();
        }
    }

    public boolean filterFromXYtoLBZ() throws ContradictionException {
        int t = ((IntVar[])this.vars)[1].getLB() - ((IntVar[])this.vars)[0].getUB();
        if (t > 0) {
            return ((IntVar[])this.vars)[2].updateLowerBound(t, this);
        }
        t = ((IntVar[])this.vars)[0].getLB() - ((IntVar[])this.vars)[1].getUB();
        return t > 0 && ((IntVar[])this.vars)[2].updateLowerBound(t, this);
    }

    public boolean filterFromXYtoUBZ() throws ContradictionException {
        int a = Math.abs(((IntVar[])this.vars)[1].getUB() - ((IntVar[])this.vars)[0].getLB());
        int b = Math.abs(((IntVar[])this.vars)[0].getUB() - ((IntVar[])this.vars)[1].getLB());
        return ((IntVar[])this.vars)[2].updateUpperBound(a > b ? a : b, this);
    }

    public boolean filterEQFromYZToX() throws ContradictionException {
        int l1 = ((IntVar[])this.vars)[1].getLB();
        int u1 = ((IntVar[])this.vars)[1].getUB();
        int l2 = ((IntVar[])this.vars)[2].getLB();
        int u2 = ((IntVar[])this.vars)[2].getUB();
        int lb = l1 - u2;
        int ub = u1 + u2;
        int lbv0 = u1 - l2 + 1;
        int ubv0 = l1 + l2 - 1;
        return ((IntVar[])this.vars)[0].updateLowerBound(lb, this) | ((IntVar[])this.vars)[0].updateUpperBound(ub, this) | ((IntVar[])this.vars)[0].removeInterval(lbv0, ubv0, this);
    }

    public boolean filterEQFromXZToY() throws ContradictionException {
        int l0 = ((IntVar[])this.vars)[0].getLB();
        int u0 = ((IntVar[])this.vars)[0].getUB();
        int l2 = ((IntVar[])this.vars)[2].getLB();
        int u2 = ((IntVar[])this.vars)[2].getUB();
        int lb = l0 - u2;
        int ub = u0 + u2;
        int lbv1 = u0 - l2 + 1;
        int ubv1 = l0 + l2 - 1;
        return ((IntVar[])this.vars)[1].updateLowerBound(lb, this) | ((IntVar[])this.vars)[1].updateUpperBound(ub, this) | ((IntVar[])this.vars)[1].removeInterval(lbv1, ubv1, this);
    }

    public boolean filterLTFromYZtoX() throws ContradictionException {
        int u2 = ((IntVar[])this.vars)[2].getUB();
        int lb = ((IntVar[])this.vars)[1].getLB() - u2 + 1;
        int ub = ((IntVar[])this.vars)[1].getUB() + u2 - 1;
        return ((IntVar[])this.vars)[0].updateLowerBound(lb, this) | ((IntVar[])this.vars)[0].updateUpperBound(ub, this);
    }

    public boolean filterLTFromXZtoY() throws ContradictionException {
        int u2 = ((IntVar[])this.vars)[2].getUB();
        int lb = ((IntVar[])this.vars)[0].getLB() - u2 + 1;
        int ub = ((IntVar[])this.vars)[0].getUB() + u2 - 1;
        return ((IntVar[])this.vars)[1].updateLowerBound(lb, this) | ((IntVar[])this.vars)[1].updateUpperBound(ub, this);
    }

    public boolean filterGTFromYZtoX() throws ContradictionException {
        int l2 = ((IntVar[])this.vars)[2].getLB();
        int lbv0 = ((IntVar[])this.vars)[1].getUB() - l2;
        int ubv0 = ((IntVar[])this.vars)[1].getLB() + l2;
        return ((IntVar[])this.vars)[0].removeInterval(lbv0, ubv0, this);
    }

    public boolean filterGTFromXZtoY() throws ContradictionException {
        int l2 = ((IntVar[])this.vars)[2].getLB();
        int lbv1 = ((IntVar[])this.vars)[0].getUB() - l2;
        int ubv1 = ((IntVar[])this.vars)[0].getLB() + l2;
        return ((IntVar[])this.vars)[1].removeInterval(lbv1, ubv1, this);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.operator == Operator.EQ) {
                return ESat.eval(Math.abs(((IntVar[])this.vars)[0].getValue() - ((IntVar[])this.vars)[1].getValue()) == ((IntVar[])this.vars)[2].getValue());
            }
            if (this.operator == Operator.LT) {
                return ESat.eval(Math.abs(((IntVar[])this.vars)[0].getValue() - ((IntVar[])this.vars)[1].getValue()) < ((IntVar[])this.vars)[2].getValue());
            }
            if (this.operator == Operator.GT) {
                return ESat.eval(Math.abs(((IntVar[])this.vars)[0].getValue() - ((IntVar[])this.vars)[1].getValue()) > ((IntVar[])this.vars)[2].getValue());
            }
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        String op;
        if (this.operator == Operator.EQ) {
            op = "=";
        } else if (this.operator == Operator.GT) {
            op = ">";
        } else if (this.operator == Operator.LT) {
            op = "<";
        } else {
            throw new SolverException("unknown operator");
        }
        return "|" + ((IntVar[])this.vars)[0] + " - " + ((IntVar[])this.vars)[1] + "| " + op + " " + ((IntVar[])this.vars)[2];
    }
}

