/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropUnion
extends Propagator<SetVar> {
    private int k;
    private ISetDeltaMonitor[] sdm;
    private IntProcedure unionForced;
    private IntProcedure unionRemoved;
    private IntProcedure setForced;
    private IntProcedure setRemoved;

    public PropUnion(SetVar[] sets, SetVar union) {
        super((Variable[])ArrayUtils.append(sets, {union}), PropagatorPriority.LINEAR, true);
        this.k = sets.length;
        this.sdm = new ISetDeltaMonitor[this.k + 1];
        for (int i = 0; i <= this.k; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.unionForced = element -> {
            int mate = -1;
            for (int i = 0; i < this.k && mate != -2; ++i) {
                if (!((SetVar[])this.vars)[i].getUB().contains(element)) continue;
                mate = mate == -1 ? i : -2;
            }
            if (mate == -1) {
                this.fails();
            } else if (mate != -2) {
                ((SetVar[])this.vars)[mate].force(element, this);
            }
        };
        this.unionRemoved = element -> {
            for (int i = 0; i < this.k; ++i) {
                ((SetVar[])this.vars)[i].remove(element, this);
            }
        };
        this.setForced = element -> ((SetVar[])this.vars)[this.k].force(element, this);
        this.setRemoved = element -> {
            if (((SetVar[])this.vars)[this.k].getUB().contains(element)) {
                int mate = -1;
                for (int i = 0; i < this.k && mate != -2; ++i) {
                    if (!((SetVar[])this.vars)[i].getUB().contains(element)) continue;
                    mate = mate == -1 ? i : -2;
                }
                if (mate == -1) {
                    ((SetVar[])this.vars)[this.k].remove(element, this);
                } else if (mate != -2 && ((SetVar[])this.vars)[this.k].getLB().contains(element)) {
                    ((SetVar[])this.vars)[mate].force(element, this);
                }
            }
        };
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            SetVar union = ((SetVar[])this.vars)[this.k];
            for (int i = 0; i < this.k; ++i) {
                ISetIterator iter = ((SetVar[])this.vars)[i].getLB().iterator();
                while (iter.hasNext()) {
                    union.force(iter.nextInt(), this);
                }
                iter = ((SetVar[])this.vars)[i].getUB().iterator();
                while (iter.hasNext()) {
                    int j = iter.nextInt();
                    if (union.getUB().contains(j)) continue;
                    ((SetVar[])this.vars)[i].remove(j, this);
                }
            }
            ISetIterator unionUB = union.getUB().iterator();
            while (unionUB.hasNext()) {
                int i;
                int mate;
                int j = unionUB.nextInt();
                if (union.getLB().contains(j)) {
                    mate = -1;
                    for (i = 0; i < this.k && mate != -2; ++i) {
                        if (!((SetVar[])this.vars)[i].getUB().contains(j)) continue;
                        mate = mate == -1 ? i : -2;
                    }
                    if (mate == -1) {
                        this.fails();
                        continue;
                    }
                    if (mate == -2) continue;
                    ((SetVar[])this.vars)[mate].force(j, this);
                    continue;
                }
                mate = -1;
                for (i = 0; i < this.k; ++i) {
                    if (!((SetVar[])this.vars)[i].getUB().contains(j)) continue;
                    mate = i;
                    break;
                }
                if (mate != -1) continue;
                union.remove(j, this);
            }
            for (int i = 0; i <= this.k; ++i) {
                this.sdm[i].unfreeze();
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.sdm[idxVarInProp].freeze();
        if (idxVarInProp < this.k) {
            this.sdm[idxVarInProp].forEach(this.setForced, SetEventType.ADD_TO_KER);
            this.sdm[idxVarInProp].forEach(this.setRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        } else {
            this.sdm[idxVarInProp].forEach(this.unionForced, SetEventType.ADD_TO_KER);
            this.sdm[idxVarInProp].forEach(this.unionRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        }
        this.sdm[idxVarInProp].unfreeze();
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.k; ++i) {
            ISetIterator iSetIterator = ((SetVar[])this.vars)[i].getLB().iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (((SetVar[])this.vars)[this.k].getUB().contains(j)) continue;
                return ESat.FALSE;
            }
        }
        ISetIterator iSetIterator = ((SetVar[])this.vars)[this.k].getLB().iterator();
        while (iSetIterator.hasNext()) {
            int j = (Integer)iSetIterator.next();
            int mate = -1;
            for (int i = 0; i < this.k; ++i) {
                if (!((SetVar[])this.vars)[i].getUB().contains(j)) continue;
                mate = i;
                break;
            }
            if (mate != -1) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

