/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropOffSet
extends Propagator<SetVar> {
    private int offSet;
    private int tmp;
    private SetVar tmpSet;
    private IntProcedure forced;
    private IntProcedure removed;
    private ISetDeltaMonitor[] sdm;

    public PropOffSet(SetVar set1, SetVar set2, int offSet) {
        super((Variable[])new SetVar[]{set1, set2}, PropagatorPriority.UNARY, true);
        this.offSet = offSet;
        this.sdm = new ISetDeltaMonitor[2];
        this.sdm[0] = ((SetVar[])this.vars)[0].monitorDelta(this);
        this.sdm[1] = ((SetVar[])this.vars)[1].monitorDelta(this);
        this.forced = i -> this.tmpSet.force(i + this.tmp, this);
        this.removed = i -> this.tmpSet.remove(i + this.tmp, this);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int j;
        ISetIterator iSetIterator = ((SetVar[])this.vars)[0].getLB().iterator();
        while (iSetIterator.hasNext()) {
            j = (Integer)iSetIterator.next();
            ((SetVar[])this.vars)[1].force(j + this.offSet, this);
        }
        iSetIterator = ((SetVar[])this.vars)[1].getLB().iterator();
        while (iSetIterator.hasNext()) {
            j = (Integer)iSetIterator.next();
            ((SetVar[])this.vars)[0].force(j - this.offSet, this);
        }
        iSetIterator = ((SetVar[])this.vars)[0].getUB().iterator();
        while (iSetIterator.hasNext()) {
            j = (Integer)iSetIterator.next();
            if (((SetVar[])this.vars)[1].getUB().contains(j + this.offSet)) continue;
            ((SetVar[])this.vars)[0].remove(j, this);
        }
        iSetIterator = ((SetVar[])this.vars)[1].getUB().iterator();
        while (iSetIterator.hasNext()) {
            j = (Integer)iSetIterator.next();
            if (((SetVar[])this.vars)[0].getUB().contains(j - this.offSet)) continue;
            ((SetVar[])this.vars)[1].remove(j, this);
        }
        this.sdm[0].unfreeze();
        this.sdm[1].unfreeze();
    }

    @Override
    public void propagate(int v, int mask) throws ContradictionException {
        this.sdm[v].freeze();
        if (v == 0) {
            this.tmp = this.offSet;
            this.tmpSet = ((SetVar[])this.vars)[1];
        } else {
            this.tmp = -this.offSet;
            this.tmpSet = ((SetVar[])this.vars)[0];
        }
        this.sdm[v].forEach(this.forced, SetEventType.ADD_TO_KER);
        this.sdm[v].forEach(this.removed, SetEventType.REMOVE_FROM_ENVELOPE);
        this.sdm[v].unfreeze();
    }

    @Override
    public ESat isEntailed() {
        int j;
        ISetIterator iSetIterator = ((SetVar[])this.vars)[0].getLB().iterator();
        while (iSetIterator.hasNext()) {
            j = (Integer)iSetIterator.next();
            if (((SetVar[])this.vars)[1].getUB().contains(j + this.offSet)) continue;
            return ESat.FALSE;
        }
        iSetIterator = ((SetVar[])this.vars)[1].getLB().iterator();
        while (iSetIterator.hasNext()) {
            j = (Integer)iSetIterator.next();
            if (((SetVar[])this.vars)[0].getUB().contains(j - this.offSet)) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

