/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropNotMemberIntSet
extends Propagator<IntVar> {
    private IntVar iv;
    private SetVar sv;

    public PropNotMemberIntSet(IntVar iv, SetVar sv) {
        super((Variable[])new IntVar[]{iv}, PropagatorPriority.UNARY, true);
        this.iv = iv;
        this.sv = sv;
    }

    @Override
    public int getPropagationConditions(int vidx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.iv.isInstantiated()) {
            this.sv.remove(this.iv.getValue(), this);
            this.setPassive();
        }
    }

    @Override
    public void propagate(int vidx, int evtmask) throws ContradictionException {
        assert (this.iv.isInstantiated());
        this.sv.remove(this.iv.getValue(), this);
        this.setPassive();
    }

    @Override
    public ESat isEntailed() {
        if (this.iv.isInstantiated()) {
            int v = this.iv.getValue();
            if (this.sv.getUB().contains(v)) {
                if (this.sv.getLB().contains(v)) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
            return ESat.TRUE;
        }
        int v = this.iv.getLB();
        while (v <= this.iv.getUB()) {
            if (!this.sv.getLB().contains(v)) {
                return ESat.UNDEFINED;
            }
            v = this.iv.nextValue(v);
        }
        return ESat.FALSE;
    }
}

