/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropNbEmpty
extends Propagator<Variable> {
    private SetVar[] sets;
    private IntVar nbEmpty;
    private int n;
    private ISet canBeEmpty;
    private ISet isEmpty;
    private IStateInt nbAlreadyEmpty;
    private IStateInt nbMaybeEmpty;

    public PropNbEmpty(SetVar[] sets, IntVar nbEmpty) {
        super(ArrayUtils.append(sets, {nbEmpty}), PropagatorPriority.UNARY, true);
        this.n = sets.length;
        this.sets = new SetVar[sets.length];
        for (int i = 0; i < sets.length; ++i) {
            this.sets[i] = (SetVar)this.vars[i];
        }
        this.nbEmpty = (IntVar)this.vars[this.n];
        IEnvironment environment = this.model.getEnvironment();
        this.canBeEmpty = SetFactory.makeStoredSet(SetType.BIPARTITESET, 0, this.model);
        this.isEmpty = SetFactory.makeStoredSet(SetType.BIPARTITESET, 0, this.model);
        this.nbAlreadyEmpty = environment.makeInt();
        this.nbMaybeEmpty = environment.makeInt();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < this.vars.length - 1) {
            return SetEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int nbMin = 0;
            int nbMax = 0;
            this.canBeEmpty.clear();
            this.isEmpty.clear();
            for (int i = 0; i < this.n; ++i) {
                if (this.sets[i].getLB().size() != 0) continue;
                ++nbMax;
                if (this.sets[i].getUB().size() == 0) {
                    ++nbMin;
                    this.isEmpty.add(i);
                    continue;
                }
                this.canBeEmpty.add(i);
            }
            this.nbAlreadyEmpty.set(nbMin);
            this.nbMaybeEmpty.set(nbMax - nbMin);
        }
        this.filter();
    }

    @Override
    public void propagate(int v, int mask) throws ContradictionException {
        if (v < this.n && this.canBeEmpty.contains(v)) {
            if (this.sets[v].getLB().size() > 0) {
                this.canBeEmpty.remove(v);
                this.nbMaybeEmpty.add(-1);
            } else if (this.sets[v].getUB().size() == 0) {
                this.isEmpty.add(v);
                this.canBeEmpty.remove(v);
                this.nbMaybeEmpty.add(-1);
                this.nbAlreadyEmpty.add(1);
            }
        }
        this.filter();
    }

    public void filter() throws ContradictionException {
        int nbMin = this.nbAlreadyEmpty.get();
        int nbMax = nbMin + this.nbMaybeEmpty.get();
        this.nbEmpty.updateBounds(nbMin, nbMax, this);
        if (this.nbEmpty.isInstantiated() && nbMin < nbMax) {
            if (this.nbEmpty.getValue() == nbMax) {
                ISetIterator iSetIterator = this.canBeEmpty.iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    ISetIterator iSetIterator2 = this.sets[i].getUB().iterator();
                    while (iSetIterator2.hasNext()) {
                        int j = (Integer)iSetIterator2.next();
                        this.sets[i].remove(j, this);
                    }
                    this.canBeEmpty.remove(i);
                    this.isEmpty.add(i);
                }
                this.setPassive();
            }
            if (this.nbEmpty.getValue() == nbMin) {
                boolean allFixed = true;
                ISetIterator iSetIterator = this.canBeEmpty.iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    if (this.sets[i].getUB().size() == 1) {
                        int val = this.sets[i].getUB().iterator().next();
                        this.sets[i].force(val, this);
                        this.canBeEmpty.remove(i);
                        continue;
                    }
                    allFixed = false;
                }
                if (allFixed) {
                    this.setPassive();
                }
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int nbMin = 0;
        int nbMax = 0;
        for (int i = 0; i < this.n; ++i) {
            if (this.sets[i].getLB().size() != 0) continue;
            ++nbMax;
            if (this.sets[i].getUB().size() != 0) continue;
            ++nbMin;
        }
        if (this.nbEmpty.getLB() > nbMax || this.nbEmpty.getUB() < nbMin) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

