/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.tools.ArrayUtils;

public class PropElement
extends Propagator<Variable> {
    private TIntArrayList constructiveDisjunction;
    private IntVar index;
    private SetVar set;
    private SetVar[] array;
    private int offSet;

    public PropElement(IntVar index, SetVar[] array, int offSet, SetVar set) {
        super(ArrayUtils.append(array, {set, index}), PropagatorPriority.LINEAR, false);
        this.index = (IntVar)this.vars[this.vars.length - 1];
        this.set = (SetVar)this.vars[this.vars.length - 2];
        this.array = new SetVar[array.length];
        for (int i = 0; i < array.length; ++i) {
            this.array[i] = (SetVar)this.vars[i];
        }
        this.offSet = offSet;
        this.constructiveDisjunction = new TIntArrayList();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.index.updateBounds(this.offSet, this.array.length - 1 + this.offSet, this);
        if (this.index.isInstantiated()) {
            this.setEq(this.set, this.array[this.index.getValue() - this.offSet]);
            this.setEq(this.array[this.index.getValue() - this.offSet], this.set);
        } else {
            int i;
            int j;
            int ub = this.index.getUB();
            boolean noEmptyKer = true;
            int i2 = this.index.getLB();
            while (i2 <= ub) {
                if (this.disjoint(this.set, this.array[i2 - this.offSet]) || this.disjoint(this.array[i2 - this.offSet], this.set)) {
                    this.index.removeValue(i2, this);
                } else if (this.array[i2 - this.offSet].getLB().size() == 0) {
                    noEmptyKer = false;
                }
                i2 = this.index.nextValue(i2);
            }
            ub = this.index.getUB();
            if (noEmptyKer) {
                int j2;
                int cd;
                this.constructiveDisjunction.clear();
                ISetIterator iter = this.array[this.index.getLB() - this.offSet].getLB().iterator();
                while (iter.hasNext()) {
                    j = iter.nextInt();
                    if (this.set.getLB().contains(j)) continue;
                    this.constructiveDisjunction.add(j);
                }
                block2: for (cd = this.constructiveDisjunction.size() - 1; cd >= 0; --cd) {
                    j2 = this.constructiveDisjunction.get(cd);
                    i = this.index.nextValue(this.index.getLB());
                    while (i <= ub) {
                        if (!this.array[i - this.offSet].getLB().contains(j2)) {
                            this.constructiveDisjunction.remove(j2);
                            continue block2;
                        }
                        i = this.index.nextValue(i);
                    }
                }
                for (cd = this.constructiveDisjunction.size() - 1; cd >= 0; --cd) {
                    j2 = this.constructiveDisjunction.get(cd);
                    this.set.force(j2, this);
                }
            }
            if (!this.set.isInstantiated()) {
                ISetIterator iter = this.set.getUB().iterator();
                while (iter.hasNext()) {
                    j = iter.nextInt();
                    boolean valueExists = false;
                    i = this.index.getLB();
                    while (i <= ub) {
                        if (this.array[i - this.offSet].getUB().contains(j)) {
                            valueExists = true;
                            break;
                        }
                        i = this.index.nextValue(i);
                    }
                    if (valueExists) continue;
                    this.set.remove(j, this);
                }
            }
        }
    }

    private void setEq(SetVar s1, SetVar s2) throws ContradictionException {
        ISetIterator iter = s2.getLB().iterator();
        while (iter.hasNext()) {
            s1.force(iter.nextInt(), this);
        }
        iter = s1.getUB().iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            if (s2.getUB().contains(j)) continue;
            s1.remove(j, this);
        }
    }

    private boolean disjoint(SetVar s1, SetVar s2) {
        ISetIterator iter = s2.getLB().iterator();
        while (iter.hasNext()) {
            if (s1.getUB().contains(iter.nextInt())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ESat isEntailed() {
        if (this.index.isInstantiated()) {
            int i = this.index.getValue() - this.offSet;
            if (i < 0 || i >= this.array.length || this.disjoint(this.set, this.array[i]) || this.disjoint(this.array[i], this.set)) {
                return ESat.FALSE;
            }
            if (this.set.isInstantiated() && this.array[i].isInstantiated()) {
                return ESat.TRUE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.UNDEFINED;
    }
}

