/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropCardinality
extends Propagator<Variable> {
    private IntVar card;
    private SetVar set;

    public PropCardinality(SetVar setVar, IntVar cardinality) {
        super(new Variable[]{setVar, cardinality}, PropagatorPriority.BINARY, false);
        this.set = (SetVar)this.vars[0];
        this.card = (IntVar)this.vars[1];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        block2: {
            int c;
            int e;
            block3: {
                int k = this.set.getLB().size();
                this.card.updateLowerBound(k, this);
                e = this.set.getUB().size();
                this.card.updateUpperBound(e, this);
                if (!this.card.isInstantiated()) break block2;
                c = this.card.getValue();
                if (c != k) break block3;
                ISetIterator iter = this.set.getUB().iterator();
                while (iter.hasNext()) {
                    int j = iter.nextInt();
                    if (this.set.getLB().contains(j)) continue;
                    this.set.remove(j, this);
                }
                break block2;
            }
            if (c != e) break block2;
            ISetIterator iter = this.set.getUB().iterator();
            while (iter.hasNext()) {
                this.set.force(iter.nextInt(), this);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int k = this.set.getLB().size();
        int e = this.set.getUB().size();
        if (k > this.card.getUB() || e < this.card.getLB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

