/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;

public class PropAtMost1Empty
extends Propagator<SetVar> {
    private IStateInt emptySetIndex;

    public PropAtMost1Empty(SetVar[] sets) {
        super((Variable[])sets, PropagatorPriority.UNARY, true);
        this.emptySetIndex = this.model.getEnvironment().makeInt(-1);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return SetEventType.REMOVE_FROM_ENVELOPE.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < ((SetVar[])this.vars).length; ++i) {
            this.propagate(i, 0);
        }
    }

    @Override
    public void propagate(int v, int mask) throws ContradictionException {
        if (((SetVar[])this.vars)[v].getUB().size() == 0) {
            if (this.emptySetIndex.get() != -1) {
                this.fails();
            } else {
                this.emptySetIndex.set(v);
                for (int i = 0; i < ((SetVar[])this.vars).length; ++i) {
                    int s = ((SetVar[])this.vars)[i].getUB().size();
                    if (i == v || s == ((SetVar[])this.vars)[i].getLB().size()) continue;
                    if (s == 0) {
                        this.fails();
                        continue;
                    }
                    if (s != 1) continue;
                    ((SetVar[])this.vars)[i].force(((SetVar[])this.vars)[i].getUB().iterator().next(), this);
                }
            }
        }
        if (((SetVar[])this.vars)[v].getUB().size() == 1 && this.emptySetIndex.get() != -1) {
            ((SetVar[])this.vars)[v].force(((SetVar[])this.vars)[v].getUB().iterator().next(), this);
        }
    }

    @Override
    public ESat isEntailed() {
        boolean none = true;
        boolean allInstantiated = true;
        for (int i = 0; i < ((SetVar[])this.vars).length; ++i) {
            if (((SetVar[])this.vars)[i].getUB().size() == 0) {
                if (!none) {
                    return ESat.FALSE;
                }
                none = false;
                continue;
            }
            if (((SetVar[])this.vars)[i].isInstantiated()) continue;
            allInstantiated = false;
        }
        if (allInstantiated) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

