/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropAllDiff
extends Propagator<SetVar> {
    private int n;

    public PropAllDiff(SetVar[] sets) {
        super((Variable[])sets, PropagatorPriority.LINEAR, true);
        this.n = sets.length;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            if (!((SetVar[])this.vars)[i].isInstantiated()) continue;
            this.propagate(i, 0);
        }
    }

    @Override
    public void propagate(int idx, int mask) throws ContradictionException {
        if (((SetVar[])this.vars)[idx].isInstantiated()) {
            int s = ((SetVar[])this.vars)[idx].getUB().size();
            for (int i = 0; i < this.n; ++i) {
                if (i == idx) continue;
                int sei = ((SetVar[])this.vars)[i].getUB().size();
                int ski = ((SetVar[])this.vars)[i].getLB().size();
                if (ski < s - 1 || sei > s + 1) continue;
                int nbSameInKer = 0;
                int diff = -1;
                ISetIterator iter = ((SetVar[])this.vars)[idx].getLB().iterator();
                while (iter.hasNext()) {
                    int j = iter.nextInt();
                    if (((SetVar[])this.vars)[i].getLB().contains(j)) {
                        ++nbSameInKer;
                        continue;
                    }
                    diff = j;
                }
                if (nbSameInKer == s) {
                    if (sei == s) {
                        this.fails();
                        continue;
                    }
                    if (sei != s + 1 || ski >= sei) continue;
                    iter = ((SetVar[])this.vars)[i].getUB().iterator();
                    while (iter.hasNext()) {
                        ((SetVar[])this.vars)[i].force(iter.nextInt(), this);
                    }
                    continue;
                }
                if (sei != s || nbSameInKer != s - 1 || !((SetVar[])this.vars)[i].getUB().contains(diff)) continue;
                ((SetVar[])this.vars)[i].remove(diff, this);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            if (!((SetVar[])this.vars)[i].isInstantiated()) {
                return ESat.UNDEFINED;
            }
            for (int i2 = i + 1; i2 < this.n; ++i2) {
                if (!this.same(i, i2)) continue;
                return ESat.FALSE;
            }
        }
        return ESat.TRUE;
    }

    private boolean same(int i, int i2) {
        if (((SetVar[])this.vars)[i].getUB().size() < ((SetVar[])this.vars)[i2].getLB().size()) {
            return false;
        }
        if (((SetVar[])this.vars)[i2].getUB().size() < ((SetVar[])this.vars)[i].getLB().size()) {
            return false;
        }
        if (((SetVar[])this.vars)[i].isInstantiated() && ((SetVar[])this.vars)[i2].isInstantiated()) {
            ISetIterator iter = ((SetVar[])this.vars)[i].getLB().iterator();
            while (iter.hasNext()) {
                if (((SetVar[])this.vars)[i2].getUB().contains(iter.nextInt())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

