/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.util.ESat;

public class PropXneCReif
extends Propagator<IntVar> {
    IntVar var;
    int cste;
    BoolVar r;

    public PropXneCReif(IntVar x, int c, BoolVar r) {
        super((Variable[])new IntVar[]{x, r}, PropagatorPriority.BINARY, false);
        this.cste = c;
        this.var = x;
        this.r = r;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.r.getLB() == 1) {
            if (this.var.removeValue(this.cste, this)) {
                this.setPassive();
            }
        } else if (this.r.getUB() == 0) {
            this.setPassive();
            this.var.instantiateTo(this.cste, this);
        } else if (!this.var.contains(this.cste)) {
            this.setPassive();
            this.r.setToTrue(this);
        } else if (this.var.isInstantiatedTo(this.cste)) {
            this.setPassive();
            this.r.setToFalse(this);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.r.isInstantiatedTo(1)) {
                return ESat.eval(!this.var.contains(this.cste));
            }
            return ESat.eval(this.var.contains(this.cste));
        }
        return ESat.UNDEFINED;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean nrules = ruleStore.addPropagatorActivationRule(this);
        nrules = var == ((IntVar[])this.vars)[1] ? (((IntVar[])this.vars)[1].isInstantiatedTo(1) ? (nrules |= ruleStore.addRemovalRule(((IntVar[])this.vars)[0], this.cste)) : (nrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[0]))) : (nrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[1]));
        return nrules;
    }

    @Override
    public String toString() {
        return "(" + this.var.getName() + " != " + this.cste + ") <=> " + this.r.getName();
    }
}

