/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

public class PropXinSReif
extends Propagator<IntVar> {
    IntVar var;
    IntIterableRangeSet set;
    BoolVar r;

    public PropXinSReif(IntVar x, IntIterableRangeSet set, BoolVar r) {
        super((Variable[])new IntVar[]{x, r}, PropagatorPriority.BINARY, false);
        this.set = set;
        this.var = x;
        this.r = r;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.r.getLB() == 1) {
            this.setPassive();
            this.var.removeAllValuesBut(this.set, this);
        } else if (this.r.getUB() == 0) {
            if (this.var.removeValues(this.set, this) || !IntIterableSetUtils.intersect(this.var, this.set)) {
                this.setPassive();
            }
        } else if (IntIterableSetUtils.includedIn(this.var, this.set)) {
            this.setPassive();
            this.r.setToTrue(this);
        } else if (!IntIterableSetUtils.intersect(this.var, this.set)) {
            this.setPassive();
            this.r.setToFalse(this);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.r.isInstantiatedTo(1)) {
                return ESat.eval(IntIterableSetUtils.includedIn(this.var, this.set));
            }
            return ESat.eval(!IntIterableSetUtils.intersect(this.var, this.set));
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return "(" + this.var.getName() + " \u2208 " + this.set + ") <=> " + this.r.getName();
    }
}

