/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.ReificationConstraint;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.util.ESat;

public class PropReif
extends Propagator<Variable> {
    private final BoolVar bVar;
    private final Constraint trueCons;
    private final Constraint falseCons;
    private ReificationConstraint reifCons;

    public PropReif(Variable[] allVars, Constraint consIfBoolTrue, Constraint consIfBoolFalse) {
        super(allVars, PropReif.computePrority(consIfBoolTrue, consIfBoolFalse), false);
        this.bVar = (BoolVar)this.vars[0];
        this.trueCons = consIfBoolTrue;
        this.falseCons = consIfBoolFalse;
    }

    public void setReifCons(ReificationConstraint reifCons) {
        assert (this.reifCons == null) : "cannot change the ReificationConstraint of a PropReif";
        this.reifCons = reifCons;
    }

    private static PropagatorPriority computePrority(Constraint consIfBoolTrue, Constraint consIfBoolFalse) {
        int p = Math.min(consIfBoolTrue.computeMaxPriority().priority, consIfBoolFalse.computeMaxPriority().priority);
        return PropagatorPriority.get(Math.min(p, PropagatorPriority.TERNARY.priority));
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.bVar.isInstantiated()) {
            this.setPassive();
            if (this.bVar.getBooleanValue() == ESat.TRUE) {
                this.reifCons.activate(0);
            } else {
                this.reifCons.activate(1);
            }
        } else {
            ESat sat = this.trueCons.isSatisfied();
            if (sat == ESat.TRUE) {
                this.setPassive();
                this.bVar.setToTrue(this);
                this.reifCons.activate(0);
            } else if (sat == ESat.FALSE) {
                this.setPassive();
                this.bVar.setToFalse(this);
                this.reifCons.activate(1);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        ESat fie;
        if (this.bVar.isInstantiated()) {
            if (this.bVar.getValue() == 1) {
                return this.trueCons.isSatisfied();
            }
            return this.falseCons.isSatisfied();
        }
        ESat tie = this.trueCons.isSatisfied();
        if (tie != ESat.UNDEFINED && tie == (fie = this.falseCons.isSatisfied())) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        if (var.equals(this.bVar)) {
            for (int i = 1; i < this.vars.length; ++i) {
                newrules |= ruleStore.addFullDomainRule((IntVar)this.vars[i]);
            }
        } else {
            newrules |= super.why(ruleStore, var, evt, value);
        }
        return newrules;
    }

    @Override
    public String toString() {
        return this.bVar.toString() + "=>" + this.trueCons.toString() + ", !" + this.bVar.toString() + "=>" + this.falseCons.toString();
    }
}

