/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public abstract class PropConditionnal
extends Propagator<Variable> {
    Constraint[] condTrue;
    Constraint[] condFalse;

    public PropConditionnal(Variable[] vars2observe, Constraint[] condTrue, Constraint[] condFalse) {
        super(vars2observe, PropagatorPriority.VERY_SLOW, false);
        this.condTrue = (Constraint[])condTrue.clone();
        this.condFalse = (Constraint[])condFalse.clone();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        block3: {
            ESat condition;
            block2: {
                condition = this.checkCondition();
                if (condition != ESat.TRUE) break block2;
                this.setPassive();
                for (Constraint cstr : this.condTrue) {
                    this.postTemp(cstr);
                }
                break block3;
            }
            if (condition != ESat.FALSE) break block3;
            this.setPassive();
            for (Constraint cstr : this.condFalse) {
                this.postTemp(cstr);
            }
        }
    }

    private void postTemp(Constraint c) throws ContradictionException {
        this.model.postTemp(c);
        this.model.getEnvironment().save(() -> this.model.unpost(c));
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    public abstract ESat checkCondition();
}

