/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.real;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.real.Ibex;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.RealEventType;
import org.chocosolver.util.ESat;

public class RealPropagator
extends Propagator<RealVar> {
    private final Ibex ibex;
    private final String functions;
    private final int contractorIdx;

    public RealPropagator(String functions, RealVar[] vars, int options) {
        super((Variable[])vars, PropagatorPriority.LINEAR, false);
        this.ibex = this.model.getIbex();
        this.functions = functions;
        this.contractorIdx = this.ibex.add_contractor(vars.length, functions, options);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return RealEventType.BOUND.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        double[] domains = new double[2 * ((RealVar[])this.vars).length];
        for (int i = 0; i < ((RealVar[])this.vars).length; ++i) {
            domains[2 * i] = ((RealVar[])this.vars)[i].getLB();
            domains[2 * i + 1] = ((RealVar[])this.vars)[i].getUB();
        }
        int result = this.ibex.contract(this.contractorIdx, domains);
        switch (result) {
            case 0: {
                this.fails();
                break;
            }
            case 2: {
                for (int i = 0; i < ((RealVar[])this.vars).length; ++i) {
                    ((RealVar[])this.vars)[i].updateBounds(domains[2 * i], domains[2 * i + 1], this);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < ((RealVar[])this.vars).length; ++i) {
                    ((RealVar[])this.vars)[i].updateBounds(domains[2 * i], domains[2 * i + 1], this);
                }
                this.setPassive();
                break;
            }
            case 4: {
                break;
            }
        }
    }

    @Override
    public ESat isEntailed() {
        double[] domains = new double[2 * ((RealVar[])this.vars).length];
        for (int i = 0; i < ((RealVar[])this.vars).length; ++i) {
            domains[2 * i] = ((RealVar[])this.vars)[i].getLB();
            domains[2 * i + 1] = ((RealVar[])this.vars)[i].getUB();
        }
        int result = this.ibex.contract(this.contractorIdx, domains);
        if (result == 0) {
            return ESat.FALSE;
        }
        for (int i = 0; i < ((RealVar[])this.vars).length; ++i) {
            if (!(((RealVar[])this.vars)[i].getLB() < domains[2 * i]) && !(((RealVar[])this.vars)[i].getUB() > domains[2 * i + 1]) || ((RealVar[])this.vars)[i].isInstantiated() || !(domains[2 * i + 1] - domains[2 * i] >= ((RealVar[])this.vars)[i].getPrecision())) continue;
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    @Override
    public String toString() {
        return super.toString() + " ->(\"" + this.functions + "\")";
    }
}

