/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue.amnv.rules;

import java.util.BitSet;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.nValue.amnv.mis.F;
import org.chocosolver.solver.constraints.nary.nValue.amnv.rules.R;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class R3
implements R {
    private int n;
    private int[] valToRem;
    private ISet[] learntEqualities;

    public R3(int nbDecVars, Model model) {
        this.n = nbDecVars;
        this.valToRem = new int[31];
        this.learntEqualities = new ISet[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.learntEqualities[i] = SetFactory.makeStoredSet(SetType.BITSET, 0, model);
        }
    }

    @Override
    public void filter(IntVar[] vars, UndirectedGraph graph, F heur, Propagator aCause) throws ContradictionException {
        int i;
        assert (this.n == vars.length - 1);
        BitSet mis = heur.getMIS();
        if (mis.cardinality() == vars[this.n].getUB()) {
            i = mis.nextClearBit(0);
            while (i >= 0 && i < this.n) {
                int lb;
                int mate = -1;
                int last = 0;
                if (this.valToRem.length < vars[i].getDomainSize()) {
                    this.valToRem = new int[vars[i].getDomainSize() * 2];
                }
                int ub = vars[i].getUB();
                int k = lb = vars[i].getLB();
                while (k <= ub) {
                    this.valToRem[last++] = k;
                    k = vars[i].nextValue(k);
                }
                ISetIterator nei = graph.getNeighOf(i).iterator();
                while (nei.hasNext()) {
                    int j = nei.nextInt();
                    if (!mis.get(j)) continue;
                    if (mate == -1) {
                        mate = j;
                    } else if (mate >= 0) {
                        mate = -2;
                    }
                    for (int ik = 0; ik < last; ++ik) {
                        if (!vars[j].contains(this.valToRem[ik]) || ik >= --last) continue;
                        this.valToRem[ik] = this.valToRem[last];
                        --ik;
                    }
                    if (mate != -2 || last != 0) continue;
                    break;
                }
                if (mate >= 0) {
                    this.enforceEq(i, mate, vars, aCause);
                } else {
                    for (int ik = 0; ik < last; ++ik) {
                        vars[i].removeValue(this.valToRem[ik], aCause);
                    }
                }
                i = mis.nextClearBit(i + 1);
            }
        }
        for (i = 0; i < this.n; ++i) {
            ISetIterator eqs = this.learntEqualities[i].iterator();
            while (eqs.hasNext()) {
                this.enforceEq(i, eqs.nextInt(), vars, aCause);
            }
        }
    }

    protected void enforceEq(int i, int j, IntVar[] vars, Propagator aCause) throws ContradictionException {
        if (i > j) {
            this.enforceEq(j, i, vars, aCause);
        } else {
            this.learntEqualities[i].add(j);
            this.learntEqualities[j].add(i);
            IntVar x = vars[i];
            IntVar y = vars[j];
            while (x.getLB() != y.getLB() || x.getUB() != y.getUB()) {
                x.updateLowerBound(y.getLB(), aCause);
                x.updateUpperBound(y.getUB(), aCause);
                y.updateLowerBound(x.getLB(), aCause);
                y.updateUpperBound(x.getUB(), aCause);
            }
            if (x.hasEnumeratedDomain() && y.hasEnumeratedDomain()) {
                int ub = x.getUB();
                int val = x.getLB();
                while (val <= ub) {
                    if (!y.contains(val)) {
                        x.removeValue(val, aCause);
                    }
                    val = x.nextValue(val);
                }
                ub = y.getUB();
                val = y.getLB();
                while (val <= ub) {
                    if (!x.contains(val)) {
                        y.removeValue(val, aCause);
                    }
                    val = y.nextValue(val);
                }
            }
        }
    }
}

