/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue.amnv.mis;

import java.util.BitSet;
import java.util.Random;
import org.chocosolver.solver.constraints.nary.nValue.amnv.mis.F;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class Rk
implements F {
    public static int defaultKValue = 30;
    protected UndirectedGraph graph;
    protected int n;
    protected int k;
    protected int iter;
    protected BitSet out;
    protected BitSet inMIS;
    protected Random rd;

    public Rk(UndirectedGraph graph, int k) {
        this.graph = graph;
        this.k = k;
        this.n = graph.getNbMaxNodes();
        this.out = new BitSet(this.n);
        this.inMIS = new BitSet(this.n);
        this.rd = new Random(0L);
    }

    public Rk(UndirectedGraph graph) {
        this(graph, defaultKValue);
    }

    @Override
    public void prepare() {
        this.iter = 0;
    }

    @Override
    public void computeMIS() {
        ++this.iter;
        this.out.clear();
        this.inMIS.clear();
        while (this.out.cardinality() < this.n) {
            int idx;
            int i = idx = this.out.nextClearBit(0);
            for (int nb = this.rd.nextInt(this.n - this.out.cardinality()); i >= 0 && i < this.n && nb >= 0; --nb) {
                idx = i;
                i = this.out.nextClearBit(i + 1);
            }
            this.inMIS.set(idx);
            this.out.set(idx);
            ISetIterator nei = this.graph.getNeighOf(idx).iterator();
            while (nei.hasNext()) {
                this.out.set(nei.nextInt());
            }
        }
    }

    @Override
    public BitSet getMIS() {
        return this.inMIS;
    }

    @Override
    public boolean hasNextMIS() {
        return this.iter < this.k;
    }
}

