/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue;

import gnu.trove.list.array.TIntArrayList;
import java.util.BitSet;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropAtMostNValues_BC
extends Propagator<IntVar> {
    private int n;
    private int nbMaxValues;
    private int minValue;
    private int minIndex;
    private int maxIndex;
    private TIntArrayList[] bound;
    private TIntArrayList stamp;
    private int[] minVal;
    private int[] maxVal;
    private BitSet kerRepresentant;
    private int[] orderedNodes;

    public PropAtMostNValues_BC(IntVar[] variables, IntVar nValues) {
        super((Variable[])ArrayUtils.concat(variables, nValues), PropagatorPriority.QUADRATIC, false);
        int i;
        this.n = variables.length;
        this.minValue = ((IntVar[])this.vars)[0].getLB();
        int maxValue = ((IntVar[])this.vars)[0].getUB();
        for (i = 1; i < this.n; ++i) {
            this.minValue = Math.min(this.minValue, ((IntVar[])this.vars)[i].getLB());
            maxValue = Math.max(maxValue, ((IntVar[])this.vars)[i].getUB());
        }
        this.nbMaxValues = maxValue - this.minValue + 1;
        this.bound = new TIntArrayList[this.nbMaxValues];
        for (i = 0; i < this.nbMaxValues; ++i) {
            this.bound[i] = new TIntArrayList();
        }
        this.minVal = new int[this.n];
        this.maxVal = new int[this.n];
        this.stamp = new TIntArrayList();
        this.kerRepresentant = new BitSet(this.n);
        this.orderedNodes = new int[this.n];
    }

    private void computeBounds() throws ContradictionException {
        this.minIndex = ((IntVar[])this.vars)[0].getLB();
        this.maxIndex = ((IntVar[])this.vars)[0].getUB();
        for (int i = 0; i < this.n; ++i) {
            this.minVal[i] = ((IntVar[])this.vars)[i].getLB();
            this.maxVal[i] = ((IntVar[])this.vars)[i].getUB();
            this.minIndex = Math.min(this.minIndex, this.minVal[i]);
            this.maxIndex = Math.max(this.maxIndex, this.maxVal[i]);
        }
        this.minIndex -= this.minValue;
        this.maxIndex -= this.minValue;
    }

    private void sortLB() {
        int i;
        for (i = 0; i < this.nbMaxValues; ++i) {
            this.bound[i].clear();
        }
        for (i = 0; i < this.n; ++i) {
            this.bound[this.minVal[i] - this.minValue].add(i);
        }
    }

    private void sortUB() {
        int i;
        for (i = 0; i < this.nbMaxValues; ++i) {
            this.bound[i].clear();
        }
        for (i = 0; i < this.n; ++i) {
            this.bound[this.maxVal[i] - this.minValue].add(i);
        }
    }

    private boolean pruneLB() throws ContradictionException {
        int node;
        int min = Integer.MIN_VALUE;
        int max = Integer.MIN_VALUE;
        int nbKer = 0;
        int index = 0;
        this.kerRepresentant.clear();
        for (int i = this.minIndex; i <= this.maxIndex; ++i) {
            for (int k = this.bound[i].size() - 1; k >= 0; --k) {
                node = this.bound[i].get(k);
                this.orderedNodes[index++] = node;
                if (min == Integer.MIN_VALUE) {
                    min = this.minVal[node];
                    max = this.maxVal[node];
                    ++nbKer;
                    continue;
                }
                if (this.minVal[node] <= max) {
                    min = Math.max(min, this.minVal[node]);
                    max = Math.min(max, this.maxVal[node]);
                    continue;
                }
                min = this.minVal[node];
                max = this.maxVal[node];
                this.kerRepresentant.set(node);
                ++nbKer;
            }
        }
        boolean hasChanged = ((IntVar[])this.vars)[this.n].updateLowerBound(nbKer, this);
        if (nbKer == ((IntVar[])this.vars)[this.n].getUB()) {
            this.stamp.clear();
            for (int i = 0; i < this.n; ++i) {
                node = this.orderedNodes[i];
                if (this.kerRepresentant.get(node)) {
                    hasChanged |= this.updateKer(this.minVal[node], true);
                    this.stamp.clear();
                }
                this.stamp.add(node);
            }
            hasChanged |= this.updateKer(Integer.MAX_VALUE, true);
        }
        return hasChanged;
    }

    private boolean pruneUB() throws ContradictionException {
        int node;
        int min = Integer.MIN_VALUE;
        int max = Integer.MIN_VALUE;
        int nbKer = 0;
        this.kerRepresentant.clear();
        int index = 0;
        for (int i = this.maxIndex; i >= this.minIndex; --i) {
            for (int k = this.bound[i].size() - 1; k >= 0; --k) {
                node = this.bound[i].get(k);
                this.orderedNodes[index++] = node;
                if (min == Integer.MIN_VALUE) {
                    min = this.minVal[node];
                    max = this.maxVal[node];
                    ++nbKer;
                    continue;
                }
                if (this.maxVal[node] >= min) {
                    max = Math.min(max, this.maxVal[node]);
                    min = Math.max(min, this.minVal[node]);
                    continue;
                }
                min = this.minVal[node];
                max = this.maxVal[node];
                this.kerRepresentant.set(node);
                ++nbKer;
            }
        }
        boolean hasChanged = ((IntVar[])this.vars)[this.n].updateLowerBound(nbKer, this);
        if (nbKer == ((IntVar[])this.vars)[this.n].getUB()) {
            this.stamp.clear();
            for (int i = 0; i < this.n; ++i) {
                node = this.orderedNodes[i];
                if (this.kerRepresentant.get(node)) {
                    hasChanged |= this.updateKer(this.maxVal[node], false);
                    this.stamp.clear();
                }
                this.stamp.add(node);
            }
            hasChanged |= this.updateKer(Integer.MIN_VALUE, false);
        }
        return hasChanged;
    }

    private boolean updateKer(int newVal, boolean LB) throws ContradictionException {
        boolean hasChanged = false;
        if (LB) {
            int i;
            int min = Integer.MIN_VALUE;
            for (i = this.stamp.size() - 1; i >= 0; --i) {
                if (((IntVar[])this.vars)[this.stamp.get(i)].getUB() >= newVal) continue;
                min = Math.max(min, ((IntVar[])this.vars)[this.stamp.get(i)].getLB());
            }
            for (i = this.stamp.size() - 1; i >= 0; --i) {
                if (((IntVar[])this.vars)[this.stamp.get(i)].getUB() >= newVal) continue;
                hasChanged |= ((IntVar[])this.vars)[this.stamp.get(i)].updateLowerBound(min, this);
            }
        } else {
            int i;
            int max = Integer.MAX_VALUE;
            for (i = this.stamp.size() - 1; i >= 0; --i) {
                if (((IntVar[])this.vars)[this.stamp.get(i)].getLB() <= newVal) continue;
                max = Math.min(max, ((IntVar[])this.vars)[this.stamp.get(i)].getUB());
            }
            for (i = this.stamp.size() - 1; i >= 0; --i) {
                if (((IntVar[])this.vars)[this.stamp.get(i)].getLB() <= newVal) continue;
                hasChanged |= ((IntVar[])this.vars)[this.stamp.get(i)].updateUpperBound(max, this);
            }
        }
        return hasChanged;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        do {
            this.computeBounds();
            this.sortLB();
            boolean hasChanged = this.pruneLB();
            this.sortUB();
        } while (hasChanged |= this.pruneUB());
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        int i;
        BitSet values = new BitSet(this.nbMaxValues);
        BitSet mandatoryValues = new BitSet(this.nbMaxValues);
        int minVal = 0;
        for (i = 0; i < this.n; ++i) {
            if (minVal <= ((IntVar[])this.vars)[i].getLB()) continue;
            minVal = ((IntVar[])this.vars)[i].getLB();
        }
        for (i = 0; i < this.n; ++i) {
            IntVar v = ((IntVar[])this.vars)[i];
            int ub = v.getUB();
            if (v.isInstantiated()) {
                mandatoryValues.set(ub - minVal);
            }
            for (int j = v.getLB(); j <= ub; ++j) {
                values.set(j - minVal);
            }
        }
        if (values.cardinality() <= ((IntVar[])this.vars)[this.n].getLB()) {
            return ESat.TRUE;
        }
        if (mandatoryValues.cardinality() > ((IntVar[])this.vars)[this.n].getUB()) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }
}

