/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue;

import gnu.trove.list.array.TIntArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropAtMostNValues
extends Propagator<IntVar> {
    private int[] concernedValues;
    private int n;
    private int[] unusedValues;
    private int[] mate;
    private boolean allEnum;
    private int[] instVals;
    private TIntArrayList dVar;
    private int minVal;
    private int nbInst;
    private BitSet valSet;

    public PropAtMostNValues(IntVar[] variables, int[] concernedValues, IntVar nValues) {
        super((Variable[])ArrayUtils.concat(variables, nValues), PropagatorPriority.QUADRATIC, false);
        this.n = variables.length;
        this.concernedValues = concernedValues;
        this.unusedValues = new int[concernedValues.length];
        this.mate = new int[concernedValues.length];
        this.allEnum = true;
        this.minVal = 0xCCCCCCC;
        int maxVal = -this.minVal;
        for (int i = 0; i < this.n; ++i) {
            this.allEnum &= ((IntVar[])this.vars)[i].hasEnumeratedDomain();
            this.minVal = Math.min(this.minVal, ((IntVar[])this.vars)[i].getLB());
            maxVal = Math.max(maxVal, ((IntVar[])this.vars)[i].getUB());
        }
        this.valSet = new BitSet(maxVal - this.minVal + 1);
        this.instVals = new int[this.n];
        this.dVar = new TIntArrayList();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[this.n].updateLowerBound(1, this);
        int count = 0;
        int countMax = 0;
        int idx = 0;
        this.nbInst = 0;
        for (int i = this.concernedValues.length - 1; i >= 0; --i) {
            boolean possible = false;
            boolean mandatory = false;
            this.mate[i] = -1;
            int value = this.concernedValues[i];
            for (int v = 0; v < this.n; ++v) {
                if (!((IntVar[])this.vars)[v].contains(value)) continue;
                possible = true;
                if (this.mate[i] == -1) {
                    this.mate[i] = v;
                } else {
                    this.mate[i] = -2;
                    if (mandatory) break;
                }
                if (!((IntVar[])this.vars)[v].isInstantiated()) continue;
                mandatory = true;
                if (this.mate[i] == -2) break;
            }
            if (possible) {
                ++countMax;
            }
            if (mandatory) {
                this.instVals[count] = value;
                ++count;
                continue;
            }
            this.unusedValues[idx++] = value;
        }
        this.nbInst = count;
        ((IntVar[])this.vars)[this.n].updateLowerBound(count, this);
        if (count != countMax && ((IntVar[])this.vars)[this.n].isInstantiated()) {
            if (count == ((IntVar[])this.vars)[this.n].getUB()) {
                int v;
                int val;
                int i;
                for (i = 0; i < idx; ++i) {
                    val = this.unusedValues[i];
                    for (v = 0; v < this.n; ++v) {
                        ((IntVar[])this.vars)[v].removeValue(val, this);
                    }
                }
                for (i = idx - 1; i >= 0; --i) {
                    val = this.unusedValues[i];
                    for (v = 0; v < this.n; ++v) {
                        ((IntVar[])this.vars)[v].removeValue(val, this);
                    }
                }
                if (this.allEnum) {
                    this.setPassive();
                }
            } else if (count == ((IntVar[])this.vars)[this.n].getUB() - 1) {
                this.filterK1Rule();
            }
        }
    }

    private void filterK1Rule() throws ContradictionException {
        int i;
        this.dVar.clear();
        for (i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated() || !this.emptyIntersectionWith(((IntVar[])this.vars)[i], this.instVals)) continue;
            this.dVar.add(i);
        }
        if (!this.dVar.isEmpty()) {
            this.intersectionDomains();
            for (i = 0; i < this.nbInst; ++i) {
                this.valSet.set(this.instVals[i] - this.minVal);
            }
            for (i = 0; i < this.n; ++i) {
                if (((IntVar[])this.vars)[i].isInstantiated()) continue;
                this.restrict(((IntVar[])this.vars)[i]);
            }
        }
    }

    private boolean emptyIntersectionWith(IntVar v, int[] valueSet) {
        for (int val : valueSet) {
            if (!v.contains(val)) continue;
            return false;
        }
        return true;
    }

    private void intersectionDomains() {
        LinkedList<Integer> inter = new LinkedList<Integer>();
        IntVar v = ((IntVar[])this.vars)[this.dVar.get(0)];
        int val = v.getLB();
        while (val <= v.getUB()) {
            inter.add(val);
            val = v.nextValue(val);
        }
        for (int i = 0; i < this.dVar.size(); ++i) {
            int next = this.dVar.get(i);
            v = ((IntVar[])this.vars)[next];
            Iterator it = inter.iterator();
            while (it.hasNext()) {
                if (v.contains((Integer)it.next())) continue;
                it.remove();
            }
        }
        this.valSet.clear();
        for (Integer i : inter) {
            this.valSet.set(i - this.minVal);
        }
    }

    private void restrict(IntVar v) throws ContradictionException {
        if (v.hasEnumeratedDomain()) {
            int val = v.getLB();
            while (val <= v.getUB()) {
                if (!this.valSet.get(val - this.minVal)) {
                    v.removeValue(val, this);
                }
                val = v.nextValue(val);
            }
        } else {
            int lb = v.getLB();
            int ub = v.getLB();
            int val = v.getLB();
            while (val <= ub && !this.valSet.get(val - this.minVal)) {
                lb = val + 1;
                val = v.nextValue(val);
            }
            val = v.getUB();
            while (val >= lb && !this.valSet.get(val - this.minVal)) {
                ub = val - 1;
                val = v.previousValue(val);
            }
            v.updateBounds(lb, ub, this);
        }
    }

    @Override
    public ESat isEntailed() {
        int countMin = 0;
        int countMax = 0;
        for (int i = 0; i < this.concernedValues.length; ++i) {
            boolean possible = false;
            boolean mandatory = false;
            for (int v = 0; v < this.n; ++v) {
                if (!((IntVar[])this.vars)[v].contains(this.concernedValues[i])) continue;
                possible = true;
                if (!((IntVar[])this.vars)[v].isInstantiated()) continue;
                mandatory = true;
                break;
            }
            if (possible) {
                ++countMax;
            }
            if (!mandatory) continue;
            ++countMin;
        }
        if (countMin > ((IntVar[])this.vars)[this.n].getUB()) {
            return ESat.FALSE;
        }
        if (countMax <= ((IntVar[])this.vars)[this.n].getLB()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

