/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nValue;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.BitSet;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.StrongConnectivityFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.procedure.UnaryIntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropAtLeastNValues_AC
extends Propagator<IntVar> {
    private int n;
    private int n2;
    private DirectedGraph digraph;
    private int[] nodeSCC;
    private BitSet free;
    private UnaryIntProcedure<Integer> remProc;
    private final IIntDeltaMonitor[] idms;
    private StrongConnectivityFinder SCCfinder;
    private int[] father;
    private BitSet in;
    private TIntIntHashMap map;
    private int[] fifo;

    public PropAtLeastNValues_AC(IntVar[] variables, int[] vals, IntVar nValues) {
        super((Variable[])ArrayUtils.concat(variables, nValues), PropagatorPriority.QUADRATIC, true);
        this.idms = new IIntDeltaMonitor[((IntVar[])this.vars).length];
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.idms[i] = ((IntVar[])this.vars)[i].monitorDelta(this);
        }
        this.n = variables.length;
        this.map = new TIntIntHashMap(vals.length);
        int idx = this.n;
        for (int i = 0; i < this.n; ++i) {
            IntVar v = ((IntVar[])this.vars)[i];
            int ub = v.getUB();
            int j = v.getLB();
            while (j <= ub) {
                if (!this.map.containsKey(j)) {
                    this.map.put(j, idx);
                    ++idx;
                }
                j = v.nextValue(j);
            }
        }
        this.n2 = idx;
        this.fifo = new int[this.n2];
        this.digraph = new DirectedGraph(this.model, this.n2 + 2, SetType.LINKED_LIST, false);
        this.free = new BitSet(this.n2);
        this.remProc = new DirectedRemProc();
        this.father = new int[this.n2];
        this.in = new BitSet(this.n2);
        this.SCCfinder = new StrongConnectivityFinder(this.digraph);
    }

    private void buildDigraph() {
        int i;
        for (int i2 = 0; i2 < this.n2; ++i2) {
            this.digraph.getSuccOf(i2).clear();
            this.digraph.getPredOf(i2).clear();
        }
        this.free.set(0, this.n2);
        for (i = 0; i < this.n2 + 2; ++i) {
            this.digraph.removeNode(i);
        }
        for (i = 0; i < this.n; ++i) {
            IntVar v = ((IntVar[])this.vars)[i];
            int ub = v.getUB();
            int k = v.getLB();
            while (k <= ub) {
                int j = this.map.get(k);
                this.digraph.addArc(i, j);
                k = v.nextValue(k);
            }
        }
    }

    private int repairMatching() throws ContradictionException {
        int i = this.free.nextSetBit(0);
        while (i >= 0 && i < this.n) {
            this.tryToMatch(i);
            i = this.free.nextSetBit(i + 1);
        }
        int card = 0;
        for (int i2 = 0; i2 < this.n; ++i2) {
            if (this.digraph.getPredOf(i2).size() <= 0) continue;
            ++card;
        }
        return card;
    }

    private void tryToMatch(int i) throws ContradictionException {
        int mate = this.augmentPath_BFS(i);
        if (mate != -1) {
            this.free.clear(mate);
            this.free.clear(i);
            int tmp = mate;
            while (tmp != i) {
                this.digraph.removeArc(this.father[tmp], tmp);
                this.digraph.addArc(tmp, this.father[tmp]);
                tmp = this.father[tmp];
            }
        }
    }

    private int augmentPath_BFS(int root) {
        this.in.clear();
        int indexFirst = 0;
        int indexLast = 0;
        this.fifo[indexLast++] = root;
        while (indexFirst != indexLast) {
            int x = this.fifo[indexFirst++];
            ISetIterator succs = this.digraph.getSuccOf(x).iterator();
            while (succs.hasNext()) {
                int y = succs.nextInt();
                if (this.in.get(y)) continue;
                this.father[y] = x;
                this.fifo[indexLast++] = y;
                this.in.set(y);
                if (!this.free.get(y)) continue;
                return y;
            }
        }
        return -1;
    }

    private void buildSCC() {
        int i;
        this.digraph.removeNode(this.n2);
        this.digraph.removeNode(this.n2 + 1);
        this.digraph.addNode(this.n2);
        this.digraph.addNode(this.n2 + 1);
        for (i = 0; i < this.n; ++i) {
            if (this.free.get(i)) {
                this.digraph.addArc(this.n2, i);
                continue;
            }
            this.digraph.addArc(i, this.n2);
        }
        for (i = this.n; i < this.n2; ++i) {
            if (this.free.get(i)) {
                this.digraph.addArc(i, this.n2 + 1);
                continue;
            }
            this.digraph.addArc(this.n2 + 1, i);
        }
        this.SCCfinder.findAllSCC();
        this.nodeSCC = this.SCCfinder.getNodesSCC();
        this.digraph.removeNode(this.n2);
        this.digraph.removeNode(this.n2 + 1);
    }

    private void filter() throws ContradictionException {
        this.buildSCC();
        for (int i = 0; i < this.n; ++i) {
            int j;
            IntVar v = ((IntVar[])this.vars)[i];
            int ub = v.getUB();
            int k = v.getLB();
            while (k <= ub) {
                j = this.map.get(k);
                if (this.nodeSCC[i] != this.nodeSCC[j]) {
                    if (this.digraph.getPredOf(i).contains(j)) {
                        v.instantiateTo(k, this);
                    } else {
                        v.removeValue(k, this);
                        this.digraph.removeArc(i, j);
                    }
                }
                k = v.nextValue(k);
            }
            if (v.hasEnumeratedDomain()) continue;
            ub = v.getUB();
            k = v.getLB();
            while (k <= ub && !this.digraph.arcExists(i, j = this.map.get(k)) && !this.digraph.arcExists(j, i)) {
                v.removeValue(k, this);
                k = v.nextValue(k);
            }
            int lb = v.getLB();
            int k2 = ub;
            while (k2 >= lb && !this.digraph.arcExists(i, j = this.map.get(k2)) && !this.digraph.arcExists(j, i)) {
                v.removeValue(k2, this);
                k2 = v.previousValue(k2);
            }
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            if (this.n2 < this.n + ((IntVar[])this.vars)[this.n].getLB()) {
                this.fails();
            }
            this.buildDigraph();
        }
        this.digraph.removeNode(this.n2);
        this.digraph.removeNode(this.n2 + 1);
        this.free.clear();
        for (i = 0; i < this.n; ++i) {
            if (this.digraph.getPredOf(i).size() != 0) continue;
            this.free.set(i);
        }
        for (i = this.n; i < this.n2; ++i) {
            if (this.digraph.getSuccOf(i).size() != 0) continue;
            this.free.set(i);
        }
        int card = this.repairMatching();
        ((IntVar[])this.vars)[this.n].updateUpperBound(card, this);
        if (((IntVar[])this.vars)[this.n].getLB() == card) {
            this.filter();
        }
        for (int i2 = 0; i2 < this.idms.length; ++i2) {
            this.idms[i2].unfreeze();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx < this.n) {
            this.idms[varIdx].freeze();
            this.idms[varIdx].forEachRemVal(this.remProc.set(varIdx));
            this.idms[varIdx].unfreeze();
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public ESat isEntailed() {
        BitSet values = new BitSet(this.n2);
        BitSet mandatoryValues = new BitSet(this.n2);
        for (int i = 0; i < this.n; ++i) {
            IntVar v = ((IntVar[])this.vars)[i];
            int ub = v.getUB();
            if (v.isInstantiated()) {
                mandatoryValues.set(this.map.get(ub));
            }
            for (int j = v.getLB(); j <= ub; ++j) {
                values.set(this.map.get(j));
            }
        }
        if (mandatoryValues.cardinality() >= ((IntVar[])this.vars)[this.n].getUB()) {
            return ESat.TRUE;
        }
        if (values.cardinality() < ((IntVar[])this.vars)[this.n].getLB()) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    private class DirectedRemProc
    implements UnaryIntProcedure<Integer> {
        private int idx;

        private DirectedRemProc() {
        }

        @Override
        public void execute(int i) throws ContradictionException {
            PropAtLeastNValues_AC.this.digraph.removeArc(this.idx, PropAtLeastNValues_AC.this.map.get(i));
            PropAtLeastNValues_AC.this.digraph.removeArc(PropAtLeastNValues_AC.this.map.get(i), this.idx);
        }

        @Override
        public UnaryIntProcedure set(Integer integer) {
            this.idx = integer;
            return this;
        }
    }
}

