/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.min_max;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropBoolMax
extends Propagator<BoolVar> {
    private final int n;
    private int x1;
    private int x2;

    public PropBoolMax(BoolVar[] variables, BoolVar maxVar) {
        super((Variable[])ArrayUtils.concat(variables, maxVar), PropagatorPriority.UNARY, true);
        this.n = variables.length;
        this.x1 = -1;
        this.x2 = -1;
        assert (this.n > 0);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.x1 = 1;
        this.x2 = 0;
        int c = 2;
        for (int i = 0; i < this.n; ++i) {
            if (c > 0 && !((BoolVar[])this.vars)[i].isInstantiated()) {
                if (c == 2) {
                    this.x1 = i;
                    if (this.x2 == i) {
                        ++this.x2;
                    }
                } else {
                    this.x2 = i;
                }
                --c;
                continue;
            }
            if (!((BoolVar[])this.vars)[i].isInstantiatedTo(1)) continue;
            ((BoolVar[])this.vars)[this.n].instantiateTo(1, this);
            if (!((BoolVar[])this.vars)[this.n].isInstantiatedTo(1)) continue;
            this.setPassive();
            return;
        }
        this.filter();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == this.n) {
            this.filter();
        } else if (((BoolVar[])this.vars)[idxVarInProp].isInstantiatedTo(1)) {
            ((BoolVar[])this.vars)[this.n].instantiateTo(1, this);
            if (((BoolVar[])this.vars)[this.n].isInstantiatedTo(1)) {
                this.setPassive();
            }
        } else if (idxVarInProp == this.x1 || idxVarInProp == this.x2) {
            if (idxVarInProp == this.x1) {
                int t = this.x1;
                this.x1 = this.x2;
                this.x2 = t;
            }
            for (int i = 0; i < this.n; ++i) {
                if (i != this.x1 && !((BoolVar[])this.vars)[i].isInstantiated()) {
                    this.x2 = i;
                    break;
                }
                if (!((BoolVar[])this.vars)[i].isInstantiatedTo(1)) continue;
                ((BoolVar[])this.vars)[this.n].instantiateTo(1, this);
                if (!((BoolVar[])this.vars)[this.n].isInstantiatedTo(1)) continue;
                this.setPassive();
                return;
            }
            this.filter();
        }
    }

    public void filter() throws ContradictionException {
        block3: {
            int bn;
            block4: {
                int b2;
                block5: {
                    int b1;
                    block2: {
                        b1 = ((BoolVar[])this.vars)[this.x1].isInstantiated() ? ((BoolVar[])this.vars)[this.x1].getValue() : 2;
                        b2 = ((BoolVar[])this.vars)[this.x2].isInstantiated() ? ((BoolVar[])this.vars)[this.x2].getValue() : 2;
                        int n = bn = ((BoolVar[])this.vars)[this.n].isInstantiated() ? ((BoolVar[])this.vars)[this.n].getValue() : 2;
                        if (b1 != 0 || b2 != 0) break block2;
                        this.setPassive();
                        ((BoolVar[])this.vars)[this.n].instantiateTo(0, this);
                        break block3;
                    }
                    if (bn != 1) break block4;
                    if (b1 != 0) break block5;
                    ((BoolVar[])this.vars)[this.x2].instantiateTo(1, this);
                    break block3;
                }
                if (b2 != 0) break block3;
                ((BoolVar[])this.vars)[this.x1].instantiateTo(1, this);
                break block3;
            }
            if (bn == 0) {
                for (int i = 0; i < this.n; ++i) {
                    ((BoolVar[])this.vars)[i].instantiateTo(0, this);
                }
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        int ub = ((BoolVar[])this.vars)[this.n].getUB();
        for (i = 0; i < this.n; ++i) {
            if (((BoolVar[])this.vars)[i].getLB() <= ub) continue;
            return ESat.FALSE;
        }
        for (i = 0; i < this.n; ++i) {
            if (((BoolVar[])this.vars)[i].getUB() <= ub) continue;
            return ESat.UNDEFINED;
        }
        if (((BoolVar[])this.vars)[this.n].isInstantiated()) {
            for (i = 0; i < this.n; ++i) {
                if (!((BoolVar[])this.vars)[i].isInstantiatedTo(ub)) continue;
                return ESat.TRUE;
            }
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append(((BoolVar[])this.vars)[this.n]).append(" = max(");
        sb.append(((BoolVar[])this.vars)[0]);
        for (int i = 1; i < this.n; ++i) {
            sb.append(", ");
            sb.append(((BoolVar[])this.vars)[i]);
        }
        sb.append(")");
        return sb.toString();
    }
}

