/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.element;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropElementV_fast
extends Propagator<IntVar> {
    private IntVar var;
    private IntVar index;
    private int offset;
    private final boolean fast;

    public PropElementV_fast(IntVar value, IntVar[] values, IntVar index, int offset, boolean fast) {
        super((Variable[])ArrayUtils.append({value, index}, values), PropagatorPriority.LINEAR, false);
        this.var = ((IntVar[])this.vars)[0];
        this.index = ((IntVar[])this.vars)[1];
        this.offset = offset;
        this.fast = fast;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        IntVar v;
        boolean filter;
        do {
            filter = this.index.updateBounds(this.offset, ((IntVar[])this.vars).length + this.offset - 3, this);
            int lb = this.index.getLB();
            int ub = this.index.getUB();
            int min = 0x3FFFFFFF;
            int max = -1073741824;
            int i = lb;
            while (i <= ub) {
                if (this.disjoint(this.var, ((IntVar[])this.vars)[2 + i - this.offset])) {
                    filter |= this.index.removeValue(i, this);
                }
                min = Math.min(min, ((IntVar[])this.vars)[2 + i - this.offset].getLB());
                max = Math.max(max, ((IntVar[])this.vars)[2 + i - this.offset].getUB());
                i = this.index.nextValue(i);
            }
            if (!this.index.hasEnumeratedDomain() && this.index.getUB() < ub) {
                i = ub - 1;
                while (i >= lb && this.disjoint(this.var, ((IntVar[])this.vars)[2 + i - this.offset])) {
                    filter |= this.index.removeValue(i, this);
                    i = this.index.previousValue(i);
                }
            }
            filter |= this.var.updateBounds(min, max, this);
            if (!this.index.isInstantiated()) continue;
            filter |= this.propagateEquality(this.var, ((IntVar[])this.vars)[2 + this.index.getValue() - this.offset]);
        } while (filter);
        if (this.var.isInstantiated() && this.index.isInstantiated() && (v = ((IntVar[])this.vars)[2 + this.index.getValue() - this.offset]).isInstantiated() && v.getValue() == this.var.getValue()) {
            this.setPassive();
        }
    }

    private boolean propagateEquality(IntVar a, IntVar b) throws ContradictionException {
        int s = a.getDomainSize() + b.getDomainSize();
        boolean filter = a.updateBounds(b.getLB(), b.getUB(), this);
        filter |= b.updateBounds(a.getLB(), a.getUB(), this);
        if (!this.fast) {
            this.filterFrom(a, b);
            this.filterFrom(b, a);
        }
        if (a.getDomainSize() + b.getDomainSize() != s) {
            filter |= this.propagateEquality(a, b);
        }
        return filter;
    }

    private boolean filterFrom(IntVar a, IntVar b) throws ContradictionException {
        boolean filter = false;
        if (a.getDomainSize() != b.getDomainSize()) {
            int lb = a.getLB();
            int ub = a.getUB();
            int i = lb;
            while (i <= ub) {
                if (!b.contains(i)) {
                    filter |= a.removeValue(i, this);
                }
                i = a.nextValue(i);
            }
        }
        return filter;
    }

    private boolean disjoint(IntVar a, IntVar b) {
        if (a.getLB() > b.getUB() || b.getLB() > a.getUB()) {
            return true;
        }
        if (this.fast) {
            return false;
        }
        int lb = a.getLB();
        int ub = a.getUB();
        int i = lb;
        while (i <= ub) {
            if (b.contains(i)) {
                return false;
            }
            i = a.nextValue(i);
        }
        return true;
    }

    @Override
    public ESat isEntailed() {
        int lb = this.index.getLB();
        int ub = this.index.getUB();
        int min = 0x3FFFFFFF;
        int max = -1073741824;
        int val = this.var.getLB();
        boolean exists = false;
        int i = lb;
        while (i <= ub) {
            int j = 2 + i - this.offset;
            if (j >= 2 && j < ((IntVar[])this.vars).length) {
                min = Math.min(min, ((IntVar[])this.vars)[j].getLB());
                max = Math.max(max, ((IntVar[])this.vars)[j].getUB());
                exists |= ((IntVar[])this.vars)[j].contains(val);
            }
            i = this.index.nextValue(i);
        }
        if (min > this.var.getUB() || max < this.var.getLB()) {
            return ESat.FALSE;
        }
        if (this.var.isInstantiated() && !exists) {
            return ESat.FALSE;
        }
        if (this.var.isInstantiated() && min == max) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean nrule = ruleStore.addPropagatorActivationRule(this);
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (var == ((IntVar[])this.vars)[i]) continue;
            nrule |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[i]);
        }
        return nrule;
    }
}

