/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import java.util.Arrays;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class TimeCumulFilter
extends CumulFilter {
    private int[] time = new int[31];

    public TimeCumulFilter(int nbMaxTasks, Propagator<IntVar> cause) {
        super(nbMaxTasks, cause);
    }

    @Override
    public void filter(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, ISet tasks) throws ContradictionException {
        int min = 0x3FFFFFFF;
        int max = -1073741824;
        ISetIterator tIter = tasks.iterator();
        while (tIter.hasNext()) {
            int i = tIter.nextInt();
            if (s[i].getUB() >= e[i].getLB()) continue;
            min = Math.min(min, s[i].getUB());
            max = Math.max(max, e[i].getLB());
        }
        if (min < max) {
            int hlb;
            int elb;
            if (max - min > this.time.length) {
                this.time = new int[max - min];
            } else {
                Arrays.fill(this.time, 0, max - min, 0);
            }
            int capaMax = capa.getUB();
            int maxC = 0;
            tIter = tasks.iterator();
            while (tIter.hasNext()) {
                int i = tIter.nextInt();
                elb = e[i].getLB();
                hlb = h[i].getLB();
                for (int t = s[i].getUB(); t < elb; ++t) {
                    int n = t - min;
                    this.time[n] = this.time[n] + hlb;
                    maxC = Math.max(maxC, this.time[t - min]);
                }
            }
            capa.updateLowerBound(maxC, this.aCause);
            tIter = tasks.iterator();
            while (tIter.hasNext()) {
                int i = tIter.nextInt();
                if (h[i].isInstantiated()) continue;
                int minH = h[i].getUB();
                elb = e[i].getLB();
                hlb = h[i].getLB();
                for (int t = s[i].getUB(); t < elb; ++t) {
                    minH = Math.min(minH, capaMax - (this.time[t - min] - hlb));
                }
                h[i].updateUpperBound(minH, this.aCause);
            }
            ISetIterator iSetIterator = tasks.iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                if (d[i].getLB() <= 0 || h[i].getLB() <= 0) continue;
                if (s[i].getLB() + d[i].getLB() > min) {
                    this.filterInf(s[i], d[i].getLB(), h[i].getLB(), min, max, this.time, capaMax);
                }
                if (e[i].getUB() - d[i].getLB() >= max) continue;
                this.filterSup(e[i], d[i].getLB(), h[i].getLB(), min, max, this.time, capaMax);
            }
        }
    }

    protected void filterInf(IntVar start, int dlb, int hlb, int min, int max, int[] time, int capaMax) throws ContradictionException {
        int nbOk = 0;
        int sub = start.getUB();
        for (int t = start.getLB(); t < sub; ++t) {
            if (t < min || t >= max || hlb + time[t - min] <= capaMax) {
                if (++nbOk != dlb) continue;
                return;
            }
            nbOk = 0;
            start.updateLowerBound(t + 1, this.aCause);
        }
    }

    protected void filterSup(IntVar end, int dlb, int hlb, int min, int max, int[] time, int capaMax) throws ContradictionException {
        int nbOk = 0;
        int elb = end.getLB();
        for (int t = end.getUB(); t > elb; --t) {
            if (t - 1 < min || t - 1 >= max || hlb + time[t - min - 1] <= capaMax) {
                if (++nbOk != dlb) continue;
                return;
            }
            nbOk = 0;
            end.updateUpperBound(t - 1, this.aCause);
        }
    }
}

