/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import gnu.trove.list.array.TIntArrayList;
import java.util.Comparator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.sort.ArraySort;

public class SweepCumulFilter
extends CumulFilter {
    protected final int[] slb;
    protected final int[] sub;
    protected final int[] elb;
    protected final int[] eub;
    protected final int[] dlb;
    protected final int[] hlb;
    protected static final int PRU = 1;
    protected static final int SCP = 2;
    protected static final int ECP = 3;
    protected final Event[] events;
    protected int nbEvents;
    protected final int[] map;
    protected final ISet tasksToUSe;
    protected boolean FIXPOINT = true;
    protected TIntArrayList temp = new TIntArrayList();
    protected TIntArrayList tprune = new TIntArrayList();
    protected ArraySort<Event> sort;
    protected Comparator<Event> eventComparator;

    public SweepCumulFilter(int n, Propagator<IntVar> cause) {
        super(n, cause);
        this.map = new int[n];
        this.slb = new int[n];
        this.sub = new int[n];
        this.elb = new int[n];
        this.eub = new int[n];
        this.dlb = new int[n];
        this.hlb = new int[n];
        this.events = new Event[3 * n];
        for (int i = 0; i < 3 * n; ++i) {
            this.events[i] = new Event();
        }
        this.tasksToUSe = SetFactory.makeBipartiteSet(0);
        this.sort = new ArraySort(this.events.length, true, false);
        this.eventComparator = (e1, e2) -> {
            if (e1.date == e2.date) {
                return e2.type - e1.type;
            }
            return e1.date - e2.date;
        };
    }

    @Override
    public void filter(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, ISet tasks) throws ContradictionException {
        boolean again;
        this.removeNullDurations(d, tasks);
        int nbT = this.tasksToUSe.size();
        do {
            int t;
            again = false;
            int i = 0;
            ISetIterator tIter = this.tasksToUSe.iterator();
            while (tIter.hasNext()) {
                t = tIter.nextInt();
                this.slb[i] = s[t].getLB();
                this.sub[i] = s[t].getUB();
                this.elb[i] = e[t].getLB();
                this.eub[i] = e[t].getUB();
                this.dlb[i] = d[t].getLB();
                this.hlb[i] = h[t].getLB();
                this.map[i] = t;
                ++i;
            }
            while (this.sweep(capa, h, nbT)) {
                again = true;
                if (this.FIXPOINT) continue;
            }
            this.pruneMin(s);
            i = 0;
            tIter = this.tasksToUSe.iterator();
            while (tIter.hasNext()) {
                t = tIter.nextInt();
                this.slb[i] = -e[t].getUB() + 1;
                this.sub[i] = -e[t].getLB() + 1;
                this.elb[i] = -s[t].getUB() + 1;
                this.eub[i] = -s[t].getLB() + 1;
                ++i;
            }
            while (this.sweep(capa, h, nbT)) {
                again = true;
                if (this.FIXPOINT) continue;
            }
            this.pruneMax(e);
        } while (this.FIXPOINT && again);
    }

    protected void removeNullDurations(IntVar[] d, ISet tasks) {
        this.tasksToUSe.clear();
        ISetIterator tIter = tasks.iterator();
        while (tIter.hasNext()) {
            int t = tIter.nextInt();
            if (d[t].getLB() <= 0) continue;
            this.tasksToUSe.add(t);
        }
    }

    protected void pruneMin(IntVar[] s) throws ContradictionException {
        int i = 0;
        ISetIterator tIter = this.tasksToUSe.iterator();
        while (tIter.hasNext()) {
            s[tIter.nextInt()].updateLowerBound(this.slb[i++], this.aCause);
        }
    }

    protected void pruneMax(IntVar[] e) throws ContradictionException {
        int i = 0;
        ISetIterator tIter = this.tasksToUSe.iterator();
        while (tIter.hasNext()) {
            e[tIter.nextInt()].updateUpperBound(1 - this.slb[i++], this.aCause);
        }
    }

    protected boolean sweep(IntVar capamax, IntVar[] h, int nbT) throws ContradictionException {
        this.generateMinEvents(nbT);
        if (this.nbEvents == 0) {
            return false;
        }
        this.sort.sort((Event[])this.events, this.nbEvents, this.eventComparator);
        int timeIndex = 0;
        int currentDate = this.events[timeIndex].date;
        this.tprune.resetQuick();
        int capa = capamax.getUB();
        int currentConso = 0;
        boolean active = false;
        block5: while (timeIndex < this.nbEvents) {
            int nextDate = this.events[timeIndex].date;
            if (currentDate < nextDate) {
                int i;
                assert (currentConso <= capa);
                this.temp.resetQuick();
                for (i = this.tprune.size() - 1; i >= 0; --i) {
                    int index = this.tprune.get(i);
                    if (currentDate >= this.sub[index] && this.sub[index] < this.elb[index]) continue;
                    if (currentConso + this.hlb[index] > capa) {
                        this.slb[index] = nextDate;
                        if (nextDate > this.sub[index]) {
                            this.aCause.fails();
                        }
                        active = true;
                        this.temp.add(index);
                        continue;
                    }
                    if (nextDate >= this.slb[index] + this.dlb[index]) continue;
                    this.temp.add(index);
                }
                this.tprune.resetQuick();
                for (i = this.temp.size() - 1; i >= 0; --i) {
                    this.tprune.add(this.temp.getQuick(i));
                }
            }
            Event event = this.events[timeIndex++];
            currentDate = event.date;
            switch (event.type) {
                case 2: {
                    capamax.updateLowerBound(currentConso += this.hlb[event.index], this.aCause);
                    continue block5;
                }
                case 3: {
                    currentConso -= this.hlb[event.index];
                    continue block5;
                }
                case 1: {
                    this.tprune.add(event.index);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("unknown event type");
        }
        return active;
    }

    protected void generateMinEvents(int nbT) {
        this.nbEvents = 0;
        for (int i = 0; i < nbT; ++i) {
            if (this.slb[i] < this.sub[i]) {
                this.events[this.nbEvents++].set(1, i, this.slb[i]);
            }
            if (this.sub[i] >= this.elb[i]) continue;
            this.events[this.nbEvents++].set(2, i, this.sub[i]);
            this.events[this.nbEvents++].set(3, i, this.elb[i]);
        }
    }

    public static class Event {
        protected int type;
        protected int index;
        protected int date;

        protected void set(int t, int i, int d) {
            this.date = d;
            this.type = t;
            this.index = i;
        }
    }
}

