/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import java.util.Arrays;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.Cumulative;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropCumulative
extends Propagator<IntVar> {
    protected final int n;
    protected final IntVar[] s;
    protected final IntVar[] d;
    protected final IntVar[] e;
    protected final IntVar[] h;
    protected final IntVar capa;
    protected CumulFilter[] filters;
    protected ISet allTasks;
    protected final IStateInt lastCapaMax;

    protected PropCumulative(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, boolean reactToFineEvt, Cumulative.Filter ... filters) {
        super((Variable[])ArrayUtils.append(s, d, e, h, {capa}), PropagatorPriority.QUADRATIC, reactToFineEvt);
        this.n = s.length;
        if (this.n != d.length || this.n != e.length || this.n != h.length) {
            throw new UnsupportedOperationException();
        }
        this.s = (IntVar[])Arrays.copyOfRange(this.vars, 0, this.n);
        this.d = (IntVar[])Arrays.copyOfRange(this.vars, this.n, this.n * 2);
        this.e = (IntVar[])Arrays.copyOfRange(this.vars, this.n * 2, this.n * 3);
        this.h = (IntVar[])Arrays.copyOfRange(this.vars, this.n * 3, this.n * 4);
        this.capa = ((IntVar[])this.vars)[4 * this.n];
        this.filters = new CumulFilter[filters.length];
        for (int f = 0; f < filters.length; ++f) {
            this.filters[f] = filters[f].make(this.n, this);
        }
        this.lastCapaMax = this.model.getEnvironment().makeInt(capa.getUB() + 1);
        this.allTasks = SetFactory.makeStoredSet(SetType.BIPARTITESET, 0, this.getModel());
        for (int t = 0; t < this.n; ++t) {
            this.allTasks.add(t);
        }
    }

    public PropCumulative(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, Cumulative.Filter ... filters) {
        this(s, d, e, h, capa, false, filters);
    }

    @Override
    public int getPropagationConditions(int idx) {
        if (idx == ((IntVar[])this.vars).length - 1) {
            return IntEventType.combine(IntEventType.INSTANTIATE, IntEventType.DECUPP);
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.propIni();
        }
        this.updateMaxCapa();
        this.filter(this.allTasks);
    }

    protected void propIni() throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            this.d[i].updateLowerBound(0, this);
            this.h[i].updateLowerBound(0, this);
            this.s[i].updateBounds(this.e[i].getLB() - this.d[i].getUB(), this.e[i].getUB() - this.d[i].getLB(), this);
            this.e[i].updateBounds(this.s[i].getLB() + this.d[i].getLB(), this.s[i].getUB() + this.d[i].getUB(), this);
            this.d[i].updateBounds(this.e[i].getLB() - this.s[i].getUB(), this.e[i].getUB() - this.s[i].getLB(), this);
        }
    }

    protected void updateMaxCapa() throws ContradictionException {
        if (this.lastCapaMax.get() != this.capa.getUB()) {
            int capaMax = this.capa.getUB();
            this.lastCapaMax.set(capaMax);
            for (int i = 0; i < this.n; ++i) {
                if (this.d[i].getLB() > 0) {
                    this.h[i].updateUpperBound(capaMax, this);
                    continue;
                }
                if (this.h[i].getLB() <= capaMax) continue;
                this.d[i].instantiateTo(0, this);
            }
        }
    }

    public void filter(ISet tasks) throws ContradictionException {
        ISetIterator tIter = tasks.iterator();
        while (tIter.hasNext()) {
            int t = tIter.nextInt();
            if (this.h[t].getUB() != 0 && this.d[t].getUB() != 0) continue;
            tasks.remove(t);
        }
        for (CumulFilter cf : this.filters) {
            cf.filter(this.s, this.d, this.e, this.h, this.capa, tasks);
        }
    }

    @Override
    public ESat isEntailed() {
        int min = this.s[0].getUB();
        int max = this.e[0].getLB();
        for (int i = 0; i < this.n; ++i) {
            min = Math.min(min, this.s[i].getUB());
            max = Math.max(max, this.e[i].getLB());
            if (this.s[i].getLB() + this.d[i].getLB() <= this.e[i].getUB() && this.s[i].getUB() + this.d[i].getUB() >= this.e[i].getLB()) continue;
            return ESat.FALSE;
        }
        int maxLoad = 0;
        if (min <= max) {
            int capamax = this.capa.getUB();
            int[] consoMin = new int[max - min];
            for (int i = 0; i < this.n; ++i) {
                for (int t = this.s[i].getUB(); t < this.e[i].getLB(); ++t) {
                    int n = t - min;
                    consoMin[n] = consoMin[n] + this.h[i].getLB();
                    if (consoMin[t - min] > capamax) {
                        return ESat.FALSE;
                    }
                    maxLoad = Math.max(maxLoad, consoMin[t - min]);
                }
            }
        }
        for (int i = 0; i < ((IntVar[])this.vars).length - 1; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) continue;
            return ESat.UNDEFINED;
        }
        assert (min <= max);
        if (maxLoad <= ((IntVar[])this.vars)[4 * this.n].getLB()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "(");
        for (int i = 0; i < this.n; ++i) {
            sb.append("[").append(((IntVar[])this.vars)[i].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 2 * this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 3 * this.n].toString()).append("],");
        }
        sb.append(((IntVar[])this.vars)[4 * this.n].toString()).append(")");
        return sb.toString();
    }
}

