/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.Cumulative;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class DefaultCumulFilter
extends CumulFilter {
    private CumulFilter time;
    private CumulFilter sweep;
    private CumulFilter nrj;
    private CumulFilter heights;
    private CumulFilter disjTaskInter;

    public DefaultCumulFilter(int nbMaxTasks, Propagator<IntVar> cause) {
        super(nbMaxTasks, cause);
        this.nrj = Cumulative.Filter.NRJ.make(nbMaxTasks, this.aCause);
    }

    @Override
    public void filter(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, ISet tasks) throws ContradictionException {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        boolean hInst = true;
        ISetIterator tIter = tasks.iterator();
        while (tIter.hasNext()) {
            int t = tIter.nextInt();
            min = Math.min(min, s[t].getLB());
            max = Math.max(max, e[t].getUB());
            hInst &= h[t].isInstantiated();
        }
        if (max - min < tasks.size() * tasks.size()) {
            this.getTime().filter(s, d, e, h, capa, tasks);
        } else {
            this.getSweep().filter(s, d, e, h, capa, tasks);
            if (!hInst) {
                this.getHeights().filter(s, d, e, h, capa, tasks);
            }
        }
        this.nrj.filter(s, d, e, h, capa, tasks);
        if (tasks.size() < 50 && capa.isInstantiatedTo(1)) {
            this.getDisjTaskInter().filter(s, d, e, h, capa, tasks);
        }
    }

    private CumulFilter getTime() {
        if (this.time == null) {
            this.time = Cumulative.Filter.TIME.make(this.nbMaxTasks, this.aCause);
        }
        return this.time;
    }

    private CumulFilter getSweep() {
        if (this.sweep == null) {
            this.sweep = Cumulative.Filter.SWEEP.make(this.nbMaxTasks, this.aCause);
        }
        return this.sweep;
    }

    private CumulFilter getHeights() {
        if (this.heights == null) {
            this.heights = Cumulative.Filter.HEIGHTS.make(this.nbMaxTasks, this.aCause);
        }
        return this.heights;
    }

    private CumulFilter getDisjTaskInter() {
        if (this.disjTaskInter == null) {
            this.disjTaskInter = Cumulative.Filter.DISJUNCTIVE_TASK_INTERVAL.make(this.nbMaxTasks, this.aCause);
        }
        return this.disjTaskInter;
    }
}

