/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.count;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropCount_AC
extends Propagator<IntVar> {
    private int n;
    private int value;
    private ISet possibles;
    private ISet mandatories;

    public PropCount_AC(IntVar[] decvars, int restrictedValue, IntVar valueCardinality) {
        super((Variable[])ArrayUtils.concat(decvars, valueCardinality), PropagatorPriority.LINEAR, true);
        this.value = restrictedValue;
        this.n = decvars.length;
        this.possibles = SetFactory.makeStoredSet(SetType.BITSET, 0, this.model);
        this.mandatories = SetFactory.makeStoredSet(SetType.BITSET, 0, this.model);
    }

    @Override
    public String toString() {
        int i;
        StringBuilder st = new StringBuilder();
        st.append("PropFastCount_(");
        for (i = 0; i < Math.min(4, ((IntVar[])this.vars).length - 1); ++i) {
            st.append(((IntVar[])this.vars)[i].getName()).append(", ");
        }
        if (i < ((IntVar[])this.vars).length - 2) {
            st.append("..., ");
        }
        st.append("limit=").append(((IntVar[])this.vars)[((IntVar[])this.vars).length - 1].getName());
        st.append(", value=").append(this.value).append(')');
        return st.toString();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.mandatories.clear();
            this.possibles.clear();
            for (int i = 0; i < this.n; ++i) {
                IntVar v = ((IntVar[])this.vars)[i];
                int ub = v.getUB();
                if (v.isInstantiated()) {
                    if (ub != this.value) continue;
                    this.mandatories.add(i);
                    continue;
                }
                if (!v.contains(this.value)) continue;
                this.possibles.add(i);
            }
        }
        this.filter();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx < this.n) {
            if (this.possibles.contains(varIdx)) {
                if (!((IntVar[])this.vars)[varIdx].contains(this.value)) {
                    this.possibles.remove(varIdx);
                    this.filter();
                } else if (((IntVar[])this.vars)[varIdx].isInstantiated()) {
                    this.possibles.remove(varIdx);
                    this.mandatories.add(varIdx);
                    this.filter();
                }
            }
        } else {
            this.filter();
        }
    }

    private void filter() throws ContradictionException {
        ((IntVar[])this.vars)[this.n].updateBounds(this.mandatories.size(), this.mandatories.size() + this.possibles.size(), this);
        if (((IntVar[])this.vars)[this.n].isInstantiated()) {
            int nb = ((IntVar[])this.vars)[this.n].getValue();
            if (this.possibles.size() + this.mandatories.size() == nb) {
                ISetIterator iter = this.possibles.iterator();
                while (iter.hasNext()) {
                    ((IntVar[])this.vars)[iter.nextInt()].instantiateTo(this.value, this);
                }
                this.setPassive();
            } else if (this.mandatories.size() == nb) {
                ISetIterator iter = this.possibles.iterator();
                while (iter.hasNext()) {
                    int j = iter.nextInt();
                    if (!((IntVar[])this.vars)[j].removeValue(this.value, this)) continue;
                    this.possibles.remove(j);
                }
                if (this.possibles.isEmpty()) {
                    this.setPassive();
                }
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == ((IntVar[])this.vars).length - 1) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.all();
    }

    @Override
    public ESat isEntailed() {
        int min = 0;
        int max = 0;
        for (int i = 0; i < this.n; ++i) {
            IntVar v = ((IntVar[])this.vars)[i];
            if (v.isInstantiatedTo(this.value)) {
                ++min;
                ++max;
                continue;
            }
            if (!v.contains(this.value)) continue;
            ++max;
        }
        if (((IntVar[])this.vars)[this.n].getLB() > max || ((IntVar[])this.vars)[this.n].getUB() < min) {
            return ESat.FALSE;
        }
        if (!((IntVar[])this.vars)[this.n].isInstantiated() || max != min) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean nrules = ruleStore.addPropagatorActivationRule(this);
        if (var == ((IntVar[])this.vars)[this.n]) {
            boolean isDecUpp = evt == IntEventType.DECUPP;
            for (int i = 0; i < this.n; ++i) {
                if (((IntVar[])this.vars)[i].contains(value)) {
                    if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
                    nrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[i]);
                    continue;
                }
                if (!isDecUpp) continue;
                nrules |= ruleStore.addRemovalRule(((IntVar[])this.vars)[i], value);
            }
        } else {
            nrules |= ruleStore.addBoundsRule(((IntVar[])this.vars)[this.n]);
            if (evt == IntEventType.REMOVE) {
                for (int i = 0; i < this.n; ++i) {
                    if (!((IntVar[])this.vars)[i].isInstantiatedTo(value)) continue;
                    nrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[i]);
                }
            } else {
                for (int i = 0; i < this.n; ++i) {
                    nrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[i]);
                }
            }
        }
        return nrules;
    }
}

