/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.circuit;

import java.util.Random;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.dominance.AbstractLengauerTarjanDominatorsFinder;
import org.chocosolver.util.graphOperations.dominance.SimpleDominatorsFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropSubcircuitDominatorFilter
extends Propagator<IntVar> {
    private DirectedGraph connectedGraph;
    private int n;
    private AbstractLengauerTarjanDominatorsFinder domFinder;
    private int offSet;
    private Random rd = new Random(0L);
    private int[] rootCandidates;
    private boolean adaptable;
    private static final int MIN_COUNTER = 10;
    private static final int MAX_COUNTER = 1000;
    private int counter = 10;

    public PropSubcircuitDominatorFilter(IntVar[] succs, int offSet, boolean adaptable) {
        super((Variable[])succs, PropagatorPriority.QUADRATIC, false);
        this.n = succs.length;
        this.offSet = offSet;
        this.connectedGraph = new DirectedGraph(this.n + 1, SetType.BITSET, false);
        this.domFinder = new SimpleDominatorsFinder(this.n, this.connectedGraph);
        this.rootCandidates = new int[this.n];
        this.adaptable = adaptable;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (int i = 0; i < this.n; ++i) {
                ((IntVar[])this.vars)[i].updateBounds(this.offSet, this.n - 1 + this.offSet, this);
            }
        }
        ++this.counter;
        this.counter = Math.min(this.counter, 1000);
        this.counter = Math.max(this.counter, 10);
        if (!this.adaptable || this.rd.nextInt(this.counter) == 0) {
            int size = 0;
            for (int i = 0; i < this.n; ++i) {
                if (((IntVar[])this.vars)[i].contains(i + this.offSet)) continue;
                this.rootCandidates[size++] = i;
            }
            if (size > 0 && (this.filterFromDom(this.rootCandidates[this.rd.nextInt(size)]) || this.reverseFilter(this.rootCandidates[this.rd.nextInt(size)]))) {
                this.propagate(PropagatorEventType.CUSTOM_PROPAGATION.getMask());
            }
        }
    }

    private boolean filterFromDom(int duplicatedNode) throws ContradictionException {
        this.clear();
        for (int i = 0; i < this.n; ++i) {
            int ub = ((IntVar[])this.vars)[i].getUB();
            int y = ((IntVar[])this.vars)[i].getLB();
            while (y <= ub) {
                if (i == duplicatedNode || i == y - this.offSet) {
                    this.connectedGraph.addArc(this.n, y - this.offSet);
                } else {
                    this.connectedGraph.addArc(i, y - this.offSet);
                }
                y = ((IntVar[])this.vars)[i].nextValue(y);
            }
        }
        boolean again = false;
        boolean hasFiltered = false;
        if (this.domFinder.findDominators()) {
            for (int x = 0; x < this.n; ++x) {
                if (x == duplicatedNode) continue;
                int ub = ((IntVar[])this.vars)[x].getUB();
                int y = ((IntVar[])this.vars)[x].getLB();
                while (y <= ub) {
                    if (x != y && this.domFinder.isDomminatedBy(x, y - this.offSet)) {
                        hasFiltered |= ((IntVar[])this.vars)[x].removeValue(y, this);
                        if (((IntVar[])this.vars)[y - this.offSet].removeValue(y, this)) {
                            again = true;
                        }
                    }
                    y = ((IntVar[])this.vars)[x].nextValue(y);
                }
            }
        } else {
            this.counter /= 2;
            this.fails();
        }
        this.counter += (hasFiltered |= again) ? -1 : 1;
        return again;
    }

    private boolean reverseFilter(int duplicatedNode) throws ContradictionException {
        this.clear();
        for (int i = 0; i < this.n; ++i) {
            int ub = ((IntVar[])this.vars)[i].getUB();
            int y = ((IntVar[])this.vars)[i].getLB();
            while (y <= ub) {
                if (y - this.offSet == duplicatedNode || i == y - this.offSet) {
                    this.connectedGraph.addArc(this.n, i);
                } else {
                    this.connectedGraph.addArc(y - this.offSet, i);
                }
                y = ((IntVar[])this.vars)[i].nextValue(y);
            }
        }
        boolean again = false;
        boolean hasFiltered = false;
        if (this.domFinder.findDominators()) {
            for (int x = 0; x < this.n; ++x) {
                int ub = ((IntVar[])this.vars)[x].getUB();
                int y = ((IntVar[])this.vars)[x].getLB();
                while (y <= ub) {
                    if (x != y && y - this.offSet != duplicatedNode && this.domFinder.isDomminatedBy(y - this.offSet, x)) {
                        hasFiltered |= ((IntVar[])this.vars)[x].removeValue(y, this);
                        if (((IntVar[])this.vars)[x].removeValue(x + this.offSet, this)) {
                            again = true;
                        }
                    }
                    y = ((IntVar[])this.vars)[x].nextValue(y);
                }
            }
        } else {
            this.counter /= 2;
            this.fails();
        }
        this.counter += (hasFiltered |= again) ? -1 : 1;
        return again;
    }

    private void clear() {
        for (int i = 0; i < this.n + 1; ++i) {
            this.connectedGraph.getSuccOf(i).clear();
            this.connectedGraph.getPredOf(i).clear();
        }
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }
}

