/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.circuit;

import gnu.trove.list.array.TIntArrayList;
import java.util.BitSet;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropSubcircuit
extends Propagator<IntVar> {
    private int n;
    private int offset;
    private IntVar length;
    private IStateInt[] origin;
    private IStateInt[] end;
    private IStateInt[] size;

    public PropSubcircuit(IntVar[] variables, int offset, IntVar length) {
        super((Variable[])variables, PropagatorPriority.UNARY, true);
        this.n = variables.length;
        this.offset = offset;
        this.length = length;
        this.origin = new IStateInt[this.n];
        this.end = new IStateInt[this.n];
        this.size = new IStateInt[this.n];
        IEnvironment environment = this.model.getEnvironment();
        for (int i = 0; i < this.n; ++i) {
            this.origin[i] = environment.makeInt(i);
            this.end[i] = environment.makeInt(i);
            this.size[i] = environment.makeInt(1);
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        TIntArrayList fixedVar = new TIntArrayList();
        for (i = 0; i < this.n; ++i) {
            ((IntVar[])this.vars)[i].updateBounds(this.offset, this.n - 1 + this.offset, this);
            if (!((IntVar[])this.vars)[i].isInstantiated() || i + this.offset == ((IntVar[])this.vars)[i].getValue()) continue;
            fixedVar.add(i);
        }
        for (i = 0; i < fixedVar.size(); ++i) {
            this.varInstantiated(fixedVar.get(i), ((IntVar[])this.vars)[fixedVar.get(i)].getValue() - this.offset);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        int next = ((IntVar[])this.vars)[idxVarInProp].getValue();
        if (idxVarInProp != next - this.offset) {
            this.varInstantiated(idxVarInProp, next - this.offset);
        }
    }

    private void varInstantiated(int var, int val) throws ContradictionException {
        if (this.isPassive()) {
            return;
        }
        int last = this.end[val].get();
        int start = this.origin[var].get();
        if (this.origin[val].get() != val) {
            this.fails();
        }
        if (this.end[var].get() != var) {
            this.fails();
        }
        if (val == start) {
            this.length.instantiateTo(this.size[start].get(), this);
        } else {
            this.size[start].add(this.size[val].get());
            if (this.size[start].get() == this.length.getUB()) {
                ((IntVar[])this.vars)[last].instantiateTo(start + this.offset, this);
                for (int i = 0; i < this.n; ++i) {
                    if (((IntVar[])this.vars)[i].isInstantiated()) continue;
                    ((IntVar[])this.vars)[i].instantiateTo(i + this.offset, this);
                }
                this.setPassive();
            }
            boolean isInst = false;
            if (this.size[start].get() < this.length.getLB() && ((IntVar[])this.vars)[last].removeValue(start + this.offset, this)) {
                isInst = ((IntVar[])this.vars)[last].isInstantiated();
            }
            this.origin[last].set(start);
            this.end[start].set(last);
            if (isInst) {
                this.varInstantiated(last, ((IntVar[])this.vars)[last].getValue() - this.offset);
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated() && this.length.isInstantiated()) {
            int ct = 0;
            int first = -1;
            BitSet visited = new BitSet(this.n);
            for (int i = 0; i < this.n; ++i) {
                if (((IntVar[])this.vars)[i].getValue() == i + this.offset) {
                    visited.set(i);
                    ++ct;
                    continue;
                }
                if (first != -1) continue;
                first = i;
            }
            if (this.length.getValue() + ct != this.n) {
                return ESat.FALSE;
            }
            if (ct == this.n) {
                return ESat.TRUE;
            }
            int x = first;
            do {
                if (visited.get(x)) {
                    return ESat.FALSE;
                }
                visited.set(x);
            } while ((x = ((IntVar[])this.vars)[x].getValue() - this.offset) != first);
            if (visited.cardinality() != this.n) {
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

