/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.channeling;

import java.util.Arrays;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.UnaryIntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropInverseChannelAC
extends Propagator<IntVar> {
    private int minX;
    private int minY;
    private int n;
    private IntVar[] X;
    private IntVar[] Y;
    private RemProc rem_proc;
    private IIntDeltaMonitor[] idms;
    private ICause cause;

    public PropInverseChannelAC(IntVar[] X, IntVar[] Y, int minX, int minY) {
        super((Variable[])ArrayUtils.append(X, Y), PropagatorPriority.LINEAR, true);
        int i;
        for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (((IntVar[])this.vars)[i].hasEnumeratedDomain()) continue;
            throw new UnsupportedOperationException("this propagator should be used with enumerated domain variables");
        }
        this.X = (IntVar[])Arrays.copyOfRange(this.vars, 0, X.length);
        this.Y = (IntVar[])Arrays.copyOfRange(this.vars, X.length, ((IntVar[])this.vars).length);
        this.n = Y.length;
        this.minX = minX;
        this.minY = minY;
        this.rem_proc = new RemProc();
        this.idms = new IIntDeltaMonitor[((IntVar[])this.vars).length];
        for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.idms[i] = ((IntVar[])this.vars)[i].monitorDelta(this);
        }
        this.cause = this;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        for (i = 0; i < this.n; ++i) {
            this.X[i].updateBounds(this.minX, this.n - 1 + this.minX, this);
            this.Y[i].updateBounds(this.minY, this.n - 1 + this.minY, this);
        }
        for (i = 0; i < this.n; ++i) {
            this.enumeratedFilteringOfX(i);
            this.enumeratedFilteringOfY(i);
        }
        for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.idms[i].unfreeze();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.idms[varIdx].freeze();
        this.idms[varIdx].forEachRemVal(this.rem_proc.set(varIdx));
        this.idms[varIdx].unfreeze();
    }

    private void enumeratedFilteringOfX(int var) throws ContradictionException {
        int min = this.X[var].getLB();
        int max = this.X[var].getUB();
        int v = min;
        while (v <= max) {
            if (!this.Y[v - this.minX].contains(var + this.minY)) {
                this.X[var].removeValue(v, this);
            }
            v = this.X[var].nextValue(v);
        }
    }

    private void enumeratedFilteringOfY(int var) throws ContradictionException {
        int min = this.Y[var].getLB();
        int max = this.Y[var].getUB();
        int v = min;
        while (v <= max) {
            if (!this.X[v - this.minY].contains(var + this.minX)) {
                this.Y[var].removeValue(v, this);
            }
            v = this.Y[var].nextValue(v);
        }
    }

    @Override
    public ESat isEntailed() {
        boolean allInst = true;
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated() || !((IntVar[])this.vars)[i + this.n].isInstantiated()) {
                allInst = false;
            }
            if (this.X[i].isInstantiated() && !this.Y[this.X[i].getValue() - this.minX].contains(i + this.minY)) {
                return ESat.FALSE;
            }
            if (!this.Y[i].isInstantiated() || this.X[this.Y[i].getValue() - this.minY].contains(i + this.minX)) continue;
            return ESat.FALSE;
        }
        if (allInst) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return "Inverse_AC({" + this.X[0] + "...}{" + this.Y[0] + "...})";
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        int idx;
        boolean nrules = ruleStore.addPropagatorActivationRule(this);
        for (idx = 0; idx < 2 * this.n && ((IntVar[])this.vars)[idx] != var; ++idx) {
        }
        if (!IntEventType.isBound(evt.getMask())) {
            assert (evt == IntEventType.REMOVE);
            nrules = idx < this.n ? (nrules |= ruleStore.addRemovalRule(this.Y[value - this.minX], idx + this.minY)) : (nrules |= ruleStore.addRemovalRule(this.X[value - this.minY], (idx -= this.n) + this.minX));
        }
        return nrules;
    }

    private class RemProc
    implements UnaryIntProcedure<Integer> {
        private int var;

        private RemProc() {
        }

        @Override
        public UnaryIntProcedure set(Integer idxVar) {
            this.var = idxVar;
            return this;
        }

        @Override
        public void execute(int val) throws ContradictionException {
            if (this.var < PropInverseChannelAC.this.n) {
                PropInverseChannelAC.this.Y[val - PropInverseChannelAC.this.minX].removeValue(this.var + PropInverseChannelAC.this.minY, PropInverseChannelAC.this.cause);
            } else {
                PropInverseChannelAC.this.X[val - PropInverseChannelAC.this.minY].removeValue(this.var - PropInverseChannelAC.this.n + PropInverseChannelAC.this.minX, PropInverseChannelAC.this.cause);
            }
        }
    }
}

