/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.channeling;

import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropClauseChanneling
extends Propagator<IntVar> {
    private IntVar iv;
    private boolean bounded;
    private IIntDeltaMonitor dm;
    private BoolVar[] eqs;
    private BoolVar[] lqs;
    private IStateInt LB;
    private IStateInt UB;
    private int OFFSET;
    private int LENGTH;

    public PropClauseChanneling(IntVar iv, BoolVar[] eb, BoolVar[] lb) {
        super((Variable[])ArrayUtils.append(new IntVar[][]{{iv}, eb, lb}), PropagatorPriority.LINEAR, true);
        this.iv = iv;
        this.bounded = !iv.hasEnumeratedDomain();
        this.eqs = eb;
        this.lqs = lb;
        this.OFFSET = iv.getLB();
        this.LENGTH = iv.getUB() - iv.getLB() + 1;
        this.LB = this.model.getEnvironment().makeInt();
        this.UB = this.model.getEnvironment().makeInt(this.LENGTH);
        IIntDeltaMonitor iIntDeltaMonitor = this.dm = iv.hasEnumeratedDomain() ? iv.monitorDelta(this) : IIntDeltaMonitor.Default.NONE;
        if (eb.length != this.LENGTH || lb.length != this.LENGTH) {
            throw new SolverException("BoolVar[] wrong dimension");
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (this.iv.isInstantiated()) {
            int value = this.iv.getValue() - this.OFFSET;
            this.eqs[value].instantiateTo(1, this);
            this.lqs[value].instantiateTo(1, this);
        }
        int lb = this.iv.getLB() - this.OFFSET;
        int ub = this.iv.getUB() - this.OFFSET;
        for (i = 0; i < lb; ++i) {
            this.eqs[i].instantiateTo(0, this);
            this.lqs[i].instantiateTo(0, this);
        }
        for (i = ub + 1; i < this.LENGTH; ++i) {
            this.eqs[i].instantiateTo(0, this);
            this.lqs[i].instantiateTo(1, this);
        }
        while (lb < this.LENGTH && this.eqs[lb].isInstantiated()) {
            if (this.eqs[lb].isInstantiatedTo(0)) {
                this.iv.removeValue(lb + this.OFFSET, this);
            } else {
                this.iv.instantiateTo(lb + this.OFFSET, this);
            }
            ++lb;
        }
        while (ub > -1 && this.eqs[ub].isInstantiated()) {
            if (this.eqs[ub].isInstantiatedTo(0)) {
                this.iv.removeValue(ub + this.OFFSET, this);
            } else {
                this.iv.instantiateTo(ub + this.OFFSET, this);
            }
            --ub;
        }
        if (!this.bounded) {
            for (i = lb + 1; i < ub; ++i) {
                if (!this.iv.contains(i + this.OFFSET)) {
                    this.eqs[i].instantiateTo(0, this);
                    continue;
                }
                if (!this.eqs[i].isInstantiated()) continue;
                if (this.eqs[i].isInstantiatedTo(0)) {
                    this.iv.removeValue(i + this.OFFSET, this);
                    continue;
                }
                this.iv.instantiateTo(i + this.OFFSET, this);
            }
        }
        while (lb < this.LENGTH && !this.iv.contains(lb + this.OFFSET)) {
            this.lqs[lb++].instantiateTo(0, this);
        }
        while (ub > -1 && !this.iv.contains(ub + this.OFFSET)) {
            this.lqs[ub--].instantiateTo(1, this);
        }
        if (ub > -1) {
            this.lqs[ub].instantiateTo(1, this);
        }
        this.LB.set(lb);
        this.UB.set(ub);
        this.dm.unfreeze();
    }

    @Override
    public void propagate(int vidx, int mask) throws ContradictionException {
        if (vidx == 0) {
            this.dm.freeze();
            if (IntEventType.isInstantiate(mask)) {
                this._inst(this.iv.getValue() - this.OFFSET);
            } else {
                int lb = this.LB.get();
                int ub = this.UB.get();
                if (IntEventType.isInclow(mask)) {
                    this._ulb(this.iv.getLB() - this.OFFSET, lb);
                }
                if (IntEventType.isDecupp(mask)) {
                    this._uub(this.iv.getUB() - this.OFFSET, ub);
                }
                this.dm.forEachRemVal(value -> {
                    if ((value -= this.OFFSET) > lb && value < ub) {
                        this.eqs[value].instantiateTo(0, this);
                    }
                });
            }
            this.dm.unfreeze();
        } else {
            int act = 0;
            if (--vidx < this.LENGTH) {
                if (this.eqs[vidx].getValue() != 1) {
                    if (vidx == this.LB.get()) {
                        act = 1;
                    } else if (vidx == this.UB.get()) {
                        act = 2;
                        --vidx;
                    } else {
                        act = 3;
                    }
                }
            } else {
                act = this.lqs[vidx -= this.LENGTH].getValue() == 1 ? 2 : 1;
            }
            switch (act) {
                case 0: {
                    this.iv.instantiateTo(vidx + this.OFFSET, this);
                    this._inst(vidx);
                    break;
                }
                case 1: {
                    this.iv.updateLowerBound(vidx + this.OFFSET + 1, this);
                    if (this.iv.isInstantiated()) {
                        this._inst(this.iv.getValue() - this.OFFSET);
                        break;
                    }
                    this._ulb(this.iv.getLB() - this.OFFSET, this.LB.get());
                    break;
                }
                case 2: {
                    this.iv.updateUpperBound(vidx + this.OFFSET, this);
                    if (this.iv.isInstantiated()) {
                        this._inst(this.iv.getValue() - this.OFFSET);
                        break;
                    }
                    this._uub(this.iv.getUB() - this.OFFSET, this.UB.get());
                    break;
                }
                case 3: {
                    this.iv.removeValue(vidx + this.OFFSET, this);
                    if (this.iv.isInstantiated()) {
                        this._inst(this.iv.getValue() - this.OFFSET);
                        break;
                    }
                    this._rem(vidx);
                }
            }
        }
    }

    private void _inst(int value) throws ContradictionException {
        this._ulb(value, this.LB.get());
        this.eqs[value].instantiateTo(1, this);
        this.lqs[value].instantiateTo(1, this);
        this._uub(value, this.UB.get());
    }

    private void _ulb(int nlb, int olb) throws ContradictionException {
        for (int i = olb; i < nlb; ++i) {
            this.eqs[i].instantiateTo(0, this);
            this.lqs[i].instantiateTo(0, this);
        }
        this.LB.set(nlb);
        if (this.eqs[nlb].isInstantiatedTo(0)) {
            ++nlb;
            while (nlb < this.LENGTH && this.eqs[nlb].isInstantiatedTo(0)) {
                ++nlb;
            }
            this.iv.updateLowerBound(nlb + this.OFFSET, this);
            if (this.iv.isInstantiated()) {
                this._inst(this.iv.getValue() - this.OFFSET);
            } else {
                this._ulb(this.iv.getLB() - this.OFFSET, this.LB.get());
            }
        }
    }

    private void _uub(int nub, int oub) throws ContradictionException {
        for (int i = oub; i > nub; --i) {
            this.eqs[i].instantiateTo(0, this);
            this.lqs[i].instantiateTo(1, this);
        }
        this.lqs[nub].instantiateTo(1, this);
        this.UB.set(nub);
        if (this.eqs[nub].isInstantiatedTo(0)) {
            --nub;
            while (nub > -1 && this.eqs[nub].isInstantiatedTo(0)) {
                --nub;
            }
            this.iv.updateUpperBound(nub + this.OFFSET, this);
            if (this.iv.isInstantiated()) {
                this._inst(this.iv.getValue() - this.OFFSET);
            } else {
                this._uub(this.iv.getUB() - this.OFFSET, this.UB.get());
            }
        }
    }

    private void _rem(int value) throws ContradictionException {
        this.eqs[value].instantiateTo(0, this);
        if (this.iv.isInstantiated()) {
            this._inst(this.iv.getValue());
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int k;
            int value = this.iv.getValue() - this.OFFSET;
            for (k = 0; k < value; ++k) {
                if (!this.eqs[k].isInstantiatedTo(1) && !this.lqs[k].isInstantiatedTo(1)) continue;
                return ESat.FALSE;
            }
            if (this.eqs[value].isInstantiatedTo(0) || this.lqs[value].isInstantiatedTo(0)) {
                return ESat.FALSE;
            }
            for (k = value + 1; k < this.LENGTH; ++k) {
                if (!this.eqs[k].isInstantiatedTo(1) && !this.lqs[k].isInstantiatedTo(0)) continue;
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean nrules = ruleStore.addPropagatorActivationRule(this);
        if (var == this.iv) {
            for (int i = 0; i < this.LENGTH; ++i) {
                nrules |= ruleStore.addFullDomainRule(this.eqs[i]);
                nrules |= ruleStore.addFullDomainRule(this.lqs[i]);
            }
        } else {
            nrules |= ruleStore.addFullDomainRule(this.iv);
        }
        return nrules;
    }
}

