/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.channeling;

import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropBitChanneling
extends Propagator<IntVar> {
    private IntVar octet;
    private BoolVar[] bits;
    private final int SIZE;
    private final int MAX;
    private IStateInt KNOW_BIT;

    public PropBitChanneling(IntVar OCTET, BoolVar[] BITS) {
        super((Variable[])ArrayUtils.append(new IntVar[][]{{OCTET}, BITS}), PropagatorPriority.LINEAR, true);
        this.octet = OCTET;
        this.bits = BITS;
        this.SIZE = BITS.length;
        this.MAX = (int)Math.pow(2.0, this.SIZE) - 1;
        this.KNOW_BIT = OCTET.getEnvironment().makeInt();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (this.octet.isInstantiated()) {
            this.setPassive();
            int value = this.octet.getValue();
            for (int i2 = 0; i2 < this.SIZE; ++i2) {
                this.bits[i2].instantiateTo((value & 1 << i2) != 0 ? 1 : 0, this);
            }
            return;
        }
        this.octet.updateBounds(0, this.MAX, this);
        int kb = 0;
        for (i = 0; i < this.SIZE; ++i) {
            if (!this.bits[i].isInstantiated()) continue;
            ++kb;
        }
        if (kb == this.SIZE) {
            this.setPassive();
            this.octet.instantiateTo(this.getValueFromBits(), this);
        } else {
            this.KNOW_BIT.set(kb);
            if (kb > 0) {
                for (i = 0; i < this.SIZE; ++i) {
                    if (!this.bits[i].isInstantiated()) continue;
                    this.removeFromOctet(i);
                }
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.setPassive();
            int value = this.octet.getValue();
            for (int i = 0; i < this.SIZE; ++i) {
                this.bits[i].instantiateTo((value & 1 << i) != 0 ? 1 : 0, this);
            }
        } else if (this.KNOW_BIT.add(1) == this.SIZE) {
            this.setPassive();
            this.octet.instantiateTo(this.getValueFromBits(), this);
        } else {
            int i = idxVarInProp - 1;
            if (this.bits[i].isInstantiated()) {
                this.removeFromOctet(i);
            }
        }
    }

    private void removeFromOctet(int bitidx) throws ContradictionException {
        int bit = 1 << bitidx;
        int from = this.octet.getLB();
        int to = this.octet.getUB();
        if (this.bits[bitidx].isInstantiatedTo(1)) {
            while (from <= to) {
                if ((from & bit) == 0) {
                    this.octet.removeValue(from, this);
                }
                from = this.octet.nextValue(from);
            }
        } else {
            while (from <= to) {
                if ((from & bit) != 0) {
                    this.octet.removeValue(from, this);
                }
                from = this.octet.nextValue(from);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.octet.getUB() < 0 || this.getValueFromBits() > this.octet.getUB() || this.getMaxValueFromBits() < this.octet.getLB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(this.octet.getValue() == this.getValueFromBits());
        }
        return ESat.UNDEFINED;
    }

    private int getMaxValueFromBits() {
        int word = 0;
        for (int i = 0; i < this.SIZE; ++i) {
            if (!this.bits[i].contains(1)) continue;
            word |= 1 << i;
        }
        return word;
    }

    private int getValueFromBits() {
        int word = 0;
        for (int i = 0; i < this.SIZE; ++i) {
            if (!this.bits[i].isInstantiatedTo(1)) continue;
            word |= 1 << i;
        }
        return word;
    }
}

