/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.binPacking;

import java.util.BitSet;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropLoadToItem
extends Propagator<IntVar> {
    private final int nbItems;
    private final int nbAvailableBins;
    private final int offset;
    private final int[] itemSize;
    private final IntVar[] binOfItem;
    private final IntVar[] binLoad;
    private BitSet binToProcess = new BitSet();

    public PropLoadToItem(IntVar[] binOfItem, int[] itemSize, IntVar[] binLoad, int offset) {
        super((Variable[])ArrayUtils.append(binLoad, binOfItem), PropagatorPriority.LINEAR, true);
        this.nbItems = binOfItem.length;
        this.nbAvailableBins = binLoad.length;
        this.itemSize = itemSize;
        this.binLoad = binLoad;
        this.binOfItem = binOfItem;
        this.offset = offset;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.nbItems; ++i) {
            this.binOfItem[i].updateBounds(this.offset, this.offset + this.nbAvailableBins - 1, this);
        }
        this.binToProcess.set(0, this.nbAvailableBins);
        while (this.binToProcess.nextSetBit(0) >= 0) {
            this.processBin(this.binToProcess.nextSetBit(0));
        }
    }

    @Override
    public void propagate(int vIdx, int evtmask) throws ContradictionException {
        int bin = vIdx < this.nbAvailableBins ? vIdx : ((IntVar[])this.vars)[vIdx].getValue() - this.offset;
        this.binToProcess.clear();
        this.binToProcess.set(bin);
        while (this.binToProcess.nextSetBit(0) >= 0) {
            this.processBin(this.binToProcess.nextSetBit(0));
        }
    }

    private void processBin(int bin) throws ContradictionException {
        this.binToProcess.clear(bin);
        int minLoad = 0;
        for (int i = 0; i < this.nbItems; ++i) {
            if (!this.binOfItem[i].isInstantiatedTo(bin + this.offset)) continue;
            minLoad += this.itemSize[i];
        }
        this.binLoad[bin].updateLowerBound(minLoad, this);
        int maxLoad = this.binLoad[bin].getUB();
        for (int i = 0; i < this.nbItems; ++i) {
            if (minLoad + this.itemSize[i] <= maxLoad || this.binOfItem[i].isInstantiated()) continue;
            this.binOfItem[i].removeValue(bin + this.offset, this);
            if (!this.binOfItem[i].isInstantiated()) continue;
            this.binToProcess.set(this.binOfItem[i].getValue() - this.offset);
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < this.nbAvailableBins) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.instantiation();
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }
}

