/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.binPacking;

import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.UnaryIntProcedure;

public class PropItemToLoad
extends Propagator<IntVar> {
    private int nbItems;
    private int nbAvailableBins;
    private int offset;
    private int[] itemSize;
    private IntVar[] binOfItem;
    private IntVar[] binLoad;
    private IStateInt[] minLoad;
    private IStateInt[] maxLoad;
    private IIntDeltaMonitor[] monitors;
    private UnaryIntProcedure<Integer> procedure = new UnaryIntProcedure<Integer>(){
        int item;

        @Override
        public UnaryIntProcedure<Integer> set(Integer itemIdx) {
            this.item = itemIdx;
            return this;
        }

        @Override
        public void execute(int bin) throws ContradictionException {
            if ((bin -= PropItemToLoad.this.offset) >= 0 && bin < PropItemToLoad.this.nbAvailableBins) {
                PropItemToLoad.this.maxLoad[bin].add(-PropItemToLoad.this.itemSize[this.item]);
                PropItemToLoad.this.binLoad[bin].updateUpperBound(PropItemToLoad.this.maxLoad[bin].get(), PropItemToLoad.this);
            }
        }
    };

    public PropItemToLoad(IntVar[] binOfItem, int[] itemSize, IntVar[] binLoad, int offset) {
        super((Variable[])binOfItem, PropagatorPriority.LINEAR, true);
        this.nbItems = binOfItem.length;
        this.nbAvailableBins = binLoad.length;
        this.itemSize = itemSize;
        this.binLoad = binLoad;
        this.binOfItem = binOfItem;
        this.offset = offset;
        this.monitors = new IIntDeltaMonitor[this.nbItems];
        for (int i = 0; i < this.nbItems; ++i) {
            this.monitors[i] = binOfItem[i].monitorDelta(this);
        }
        this.minLoad = new IStateInt[this.nbAvailableBins];
        this.maxLoad = new IStateInt[this.nbAvailableBins];
        for (int b = 0; b < this.nbAvailableBins; ++b) {
            this.minLoad[b] = this.model.getEnvironment().makeInt(0);
            this.maxLoad[b] = this.model.getEnvironment().makeInt(0);
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        for (i = 0; i < this.nbItems; ++i) {
            if (this.binOfItem[i].isInstantiated()) {
                int val = this.binOfItem[i].getValue() - this.offset;
                if (val < 0 || val >= this.nbAvailableBins) continue;
                this.minLoad[val].add(this.itemSize[i]);
                this.maxLoad[val].add(this.itemSize[i]);
                continue;
            }
            IntVar vr = this.binOfItem[i];
            int ub = vr.getUB();
            int val = vr.getLB();
            while (val <= ub) {
                if (val >= this.offset && val < this.offset + this.nbAvailableBins) {
                    this.maxLoad[val - this.offset].add(this.itemSize[i]);
                }
                val = vr.nextValue(val);
            }
        }
        for (int b = 0; b < this.nbAvailableBins; ++b) {
            this.binLoad[b].updateBounds(this.minLoad[b].get(), this.maxLoad[b].get(), this);
        }
        for (i = 0; i < this.nbItems; ++i) {
            this.monitors[i].unfreeze();
        }
    }

    @Override
    public void propagate(int item, int evtmask) throws ContradictionException {
        this.monitors[item].freeze();
        this.monitors[item].forEachRemVal(this.procedure.set(item));
        this.monitors[item].unfreeze();
        if (this.binOfItem[item].isInstantiated()) {
            int bin = this.binOfItem[item].getValue() - this.offset;
            if (bin >= 0 && bin < this.nbAvailableBins) {
                this.minLoad[bin].add(this.itemSize[item]);
                this.binLoad[bin].updateLowerBound(this.minLoad[bin].get(), this);
            } else {
                this.fails();
            }
        }
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.nbItems; ++i) {
            int val;
            if (!this.binOfItem[i].isInstantiated() || (val = this.binOfItem[i].getValue()) >= this.offset && val < this.nbAvailableBins + this.offset) continue;
            return ESat.FALSE;
        }
        for (int b = 0; b < this.nbAvailableBins; ++b) {
            int min = 0;
            int max = 0;
            for (int i = 0; i < this.nbItems; ++i) {
                if (!this.binOfItem[i].contains(b + this.offset)) continue;
                max += this.itemSize[i];
                if (!this.binOfItem[i].isInstantiated()) continue;
                min += this.itemSize[i];
            }
            if (min <= this.binLoad[b].getUB() && max >= this.binLoad[b].getLB()) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

