/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata.structure.costregular;

import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.stack.TIntStack;
import gnu.trove.stack.array.TIntArrayStack;
import java.util.BitSet;
import java.util.Set;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateDoubleVector;
import org.chocosolver.memory.IStateIntVector;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.automata.structure.Node;
import org.chocosolver.solver.constraints.nary.automata.structure.costregular.Arc;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableIntIterator;
import org.chocosolver.util.objects.StoredIndexedBipartiteSet;
import org.chocosolver.util.objects.StoredIndexedBipartiteSetWithOffset;
import org.jgrapht.graph.DirectedMultigraph;

public class StoredValuedDirectedMultiGraph {
    private int[] starts;
    private int[] offsets;
    public int sourceIndex;
    public int tinkIndex;
    private StoredIndexedBipartiteSetWithOffset[] supports;
    public int[][] layers;
    public BitSet inStack;
    public StoredIndexedBipartiteSet inGraph;
    public TIntStack toUpdateLeft;
    public TIntStack toUpdateRight;
    public Nodes GNodes;
    public Arcs GArcs;

    public StoredValuedDirectedMultiGraph(IEnvironment environment, DirectedMultigraph<Node, Arc> graph, int[][] layers, int[] starts, int[] offsets, int supportLength) {
        this.starts = starts;
        this.offsets = offsets;
        this.layers = layers;
        this.sourceIndex = layers[0][0];
        this.tinkIndex = layers[layers.length - 1][0];
        this.toUpdateLeft = new TIntArrayStack();
        this.toUpdateRight = new TIntArrayStack();
        this.GNodes = new Nodes();
        this.GArcs = new Arcs();
        TIntHashSet[] sups = new TIntHashSet[supportLength];
        this.supports = new StoredIndexedBipartiteSetWithOffset[supportLength];
        Set arcs = graph.edgeSet();
        this.inStack = new BitSet(arcs.size());
        this.GArcs.values = new int[arcs.size()];
        this.GArcs.dests = new int[arcs.size()];
        this.GArcs.origs = new int[arcs.size()];
        this.GArcs.costs = new double[arcs.size()];
        int[] inginit = new int[arcs.size()];
        int tmp = 0;
        for (Arc a : arcs) {
            inginit[tmp++] = a.id;
            this.GArcs.values[a.id] = a.value;
            this.GArcs.dests[a.id] = a.dest.id;
            this.GArcs.origs[a.id] = a.orig.id;
            this.GArcs.costs[a.id] = a.cost;
            if (a.orig.layer >= starts.length) continue;
            int idx = starts[a.orig.layer] + a.value - offsets[a.orig.layer];
            if (sups[idx] == null) {
                sups[idx] = new TIntHashSet();
            }
            sups[idx].add(a.id);
        }
        this.inGraph = new StoredIndexedBipartiteSet(environment, inginit);
        for (int i = 0; i < sups.length; ++i) {
            if (sups[i] == null) continue;
            this.supports[i] = new StoredIndexedBipartiteSetWithOffset(environment, sups[i].toArray());
        }
        Set nodes = graph.vertexSet();
        this.GNodes.outArcs = new StoredIndexedBipartiteSetWithOffset[nodes.size()];
        this.GNodes.inArcs = new StoredIndexedBipartiteSetWithOffset[nodes.size()];
        this.GNodes.layers = new int[nodes.size()];
        this.GNodes.states = new int[nodes.size()];
        this.GNodes.prevLP = environment.makeIntVector(nodes.size(), Integer.MIN_VALUE);
        this.GNodes.nextLP = environment.makeIntVector(nodes.size(), Integer.MIN_VALUE);
        this.GNodes.prevSP = environment.makeIntVector(nodes.size(), Integer.MIN_VALUE);
        this.GNodes.nextSP = environment.makeIntVector(nodes.size(), Integer.MIN_VALUE);
        this.GNodes.lpfs = environment.makeDoubleVector(nodes.size(), Double.NEGATIVE_INFINITY);
        this.GNodes.lpft = environment.makeDoubleVector(nodes.size(), Double.NEGATIVE_INFINITY);
        this.GNodes.spfs = environment.makeDoubleVector(nodes.size(), Double.POSITIVE_INFINITY);
        this.GNodes.spft = environment.makeDoubleVector(nodes.size(), Double.POSITIVE_INFINITY);
        for (Node n : nodes) {
            Set inarc;
            int i;
            this.GNodes.layers[n.id] = n.layer;
            this.GNodes.states[n.id] = n.state;
            Set outarc = graph.outgoingEdgesOf(n);
            if (!outarc.isEmpty()) {
                int[] out = new int[outarc.size()];
                i = 0;
                for (Arc a : outarc) {
                    out[i++] = a.id;
                }
                this.GNodes.outArcs[n.id] = new StoredIndexedBipartiteSetWithOffset(environment, out);
            }
            if ((inarc = graph.incomingEdgesOf(n)).isEmpty()) continue;
            int[] in = new int[inarc.size()];
            i = 0;
            for (Arc a : inarc) {
                in[i++] = a.id;
            }
            this.GNodes.inArcs[n.id] = new StoredIndexedBipartiteSetWithOffset(environment, in);
        }
        this.initPathInfo();
    }

    public void initPathInfo() {
        double otherL;
        double otherS;
        double acost;
        int arc;
        DisposableIntIterator it;
        int[] layer;
        int i;
        int start = this.layers[0][0];
        int end = this.layers[this.layers.length - 1][0];
        this.GNodes.spfs.quickSet(start, 0.0);
        this.GNodes.lpfs.quickSet(start, 0.0);
        this.GNodes.spft.quickSet(end, 0.0);
        this.GNodes.lpft.quickSet(end, 0.0);
        for (i = 1; i < this.layers.length; ++i) {
            for (int q : layer = this.layers[i]) {
                it = this.GNodes.inArcs[q].getIterator();
                while (it.hasNext()) {
                    arc = it.next();
                    acost = this.GArcs.costs[arc];
                    int orig = this.GArcs.origs[arc];
                    otherS = this.GNodes.spfs.quickGet(orig) + acost;
                    if (otherS < this.GNodes.spfs.quickGet(q)) {
                        this.GNodes.spfs.quickSet(q, otherS);
                        this.GNodes.prevSP.quickSet(q, arc);
                    }
                    if (!((otherL = this.GNodes.lpfs.quickGet(orig) + acost) > this.GNodes.lpfs.quickGet(q))) continue;
                    this.GNodes.lpfs.quickSet(q, otherL);
                    this.GNodes.prevLP.quickSet(q, arc);
                }
                it.dispose();
            }
        }
        for (i = this.layers.length - 2; i >= 0; --i) {
            for (int q : layer = this.layers[i]) {
                it = this.GNodes.outArcs[q].getIterator();
                while (it.hasNext()) {
                    arc = it.next();
                    acost = this.GArcs.costs[arc];
                    int dest = this.GArcs.dests[arc];
                    otherS = this.GNodes.spft.quickGet(dest) + acost;
                    if (otherS < this.GNodes.spft.quickGet(q)) {
                        this.GNodes.spft.quickSet(q, otherS);
                        this.GNodes.nextSP.quickSet(q, arc);
                    }
                    if (!((otherL = this.GNodes.lpft.quickGet(dest) + acost) > this.GNodes.lpft.quickGet(q))) continue;
                    this.GNodes.lpft.quickSet(q, otherL);
                    this.GNodes.nextLP.quickSet(q, arc);
                }
                it.dispose();
            }
        }
    }

    public final StoredIndexedBipartiteSetWithOffset getSupport(int i, int j) {
        int idx = this.starts[i] + j - this.offsets[i];
        return this.supports[idx];
    }

    public void removeArc(int arcId, TIntStack toRemove, Propagator<IntVar> propagator, ICause aCause) throws ContradictionException {
        this.clearInStack(arcId);
        this.inGraph.remove(arcId);
        int orig = this.GArcs.origs[arcId];
        int dest = this.GArcs.dests[arcId];
        int layer = this.GNodes.layers[orig];
        int value = this.GArcs.values[arcId];
        if (layer < this.starts.length) {
            StoredIndexedBipartiteSetWithOffset support = this.getSupport(layer, value);
            support.remove(arcId);
            if (support.isEmpty()) {
                IntVar var = propagator.getVar(layer);
                var.removeValue(value, aCause);
            }
        }
        StoredIndexedBipartiteSetWithOffset out = this.GNodes.outArcs[orig];
        out.remove(arcId);
        StoredIndexedBipartiteSetWithOffset in = this.GNodes.inArcs[dest];
        in.remove(arcId);
        if (this.GNodes.nextSP.quickGet(orig) == arcId || this.GNodes.nextLP.quickGet(orig) == arcId) {
            this.updateRight(orig, toRemove, propagator);
        }
        if (this.GNodes.prevSP.quickGet(dest) == arcId || this.GNodes.prevLP.quickGet(dest) == arcId) {
            this.updateLeft(dest, toRemove, propagator);
        }
    }

    public void updateRight(int nid, TIntStack toRemove, Propagator<IntVar> propagator) {
        double tempPval = Double.POSITIVE_INFINITY;
        double tempPval2 = Double.NEGATIVE_INFINITY;
        int tempP = Integer.MIN_VALUE;
        int temp2 = Integer.MIN_VALUE;
        DisposableIntIterator it = this.GNodes.outArcs[nid].getIterator();
        while (it.hasNext()) {
            double lpft;
            int arcId = it.next();
            int dest = this.GArcs.dests[arcId];
            double spft = this.GNodes.spft.quickGet(dest) + this.GArcs.costs[arcId];
            if (tempPval > spft) {
                tempPval = spft;
                tempP = arcId;
            }
            if (!(tempPval2 < (lpft = this.GNodes.lpft.quickGet(dest) + this.GArcs.costs[arcId]))) continue;
            tempPval2 = lpft;
            temp2 = arcId;
        }
        it.dispose();
        double old = this.GNodes.spft.quickSet(nid, tempPval);
        this.GNodes.nextSP.quickSet(nid, tempP);
        double old2 = this.GNodes.lpft.quickSet(nid, tempPval2);
        this.GNodes.nextLP.quickSet(nid, temp2);
        if (nid != this.sourceIndex && (old != tempPval || old2 != tempPval2)) {
            it = this.GNodes.inArcs[nid].getIterator();
            while (it.hasNext()) {
                int arcId = it.next();
                int orig = this.GArcs.origs[arcId];
                if (this.GNodes.nextSP.quickGet(orig) == arcId && old != tempPval || old2 != tempPval2 && this.GNodes.nextLP.quickGet(orig) == arcId) {
                    this.toUpdateRight.push(orig);
                }
                double spfs = this.GNodes.spfs.quickGet(orig);
                double lpfs = this.GNodes.lpfs.quickGet(orig);
                double acost = this.GArcs.costs[arcId];
                if (!this.isNotInStack(arcId) || !(tempPval + spfs + acost > (double)propagator.getVar(this.starts.length).getUB()) && !(tempPval2 + lpfs + acost < (double)propagator.getVar(this.starts.length).getLB())) continue;
                this.setInStack(arcId);
                toRemove.push(arcId);
            }
            it.dispose();
        }
    }

    @Deprecated
    public void updateSPFT(int nid, TIntStack toRemove, Propagator<IntVar> propagator) {
        double tempPval = Double.POSITIVE_INFINITY;
        int tempP = Integer.MIN_VALUE;
        DisposableIntIterator it = this.GNodes.outArcs[nid].getIterator();
        while (it.hasNext()) {
            int arcId = it.next();
            int dest = this.GArcs.dests[arcId];
            double spft = this.GNodes.spft.quickGet(dest) + this.GArcs.costs[arcId];
            if (!(tempPval > spft)) continue;
            tempPval = spft;
            tempP = arcId;
        }
        it.dispose();
        double old = this.GNodes.spft.quickSet(nid, tempPval);
        this.GNodes.nextSP.quickSet(nid, tempP);
        if (nid != this.sourceIndex && old != tempPval) {
            it = this.GNodes.inArcs[nid].getIterator();
            while (it.hasNext()) {
                int arcId = it.next();
                int orig = this.GArcs.origs[arcId];
                if (this.GNodes.nextSP.quickGet(orig) == arcId) {
                    this.updateSPFT(orig, toRemove, propagator);
                }
                double spfs = this.GNodes.spfs.quickGet(orig);
                double acost = this.GArcs.costs[arcId];
                if (!this.isNotInStack(arcId) || !(tempPval + spfs + acost > (double)propagator.getVar(this.starts.length).getUB())) continue;
                this.setInStack(arcId);
                toRemove.push(arcId);
            }
            it.dispose();
        }
    }

    @Deprecated
    public void updateLPFT(int nid, TIntStack toRemove, Propagator<IntVar> propagator) {
        double tempPval = Double.NEGATIVE_INFINITY;
        int tempP = Integer.MIN_VALUE;
        DisposableIntIterator it = this.GNodes.outArcs[nid].getIterator();
        while (it.hasNext()) {
            int arcId = it.next();
            int dest = this.GArcs.dests[arcId];
            double lpft = this.GNodes.lpft.quickGet(dest) + this.GArcs.costs[arcId];
            if (!(tempPval < lpft)) continue;
            tempPval = lpft;
            tempP = arcId;
        }
        it.dispose();
        double old = this.GNodes.lpft.quickSet(nid, tempPval);
        this.GNodes.nextLP.quickSet(nid, tempP);
        if (nid != this.sourceIndex && old != tempPval) {
            it = this.GNodes.inArcs[nid].getIterator();
            while (it.hasNext()) {
                int arcId = it.next();
                int orig = this.GArcs.origs[arcId];
                if (this.GNodes.nextLP.quickGet(orig) == arcId) {
                    this.updateLPFT(orig, toRemove, propagator);
                }
                double lpfs = this.GNodes.lpfs.quickGet(orig);
                double acost = this.GArcs.costs[arcId];
                if (!this.isNotInStack(arcId) || !(tempPval + lpfs + acost < (double)propagator.getVar(this.starts.length).getLB())) continue;
                this.setInStack(arcId);
                toRemove.push(arcId);
            }
            it.dispose();
        }
    }

    public void updateLeft(int nid, TIntStack toRemove, Propagator<IntVar> propagator) {
        double tempPval = Double.POSITIVE_INFINITY;
        int tempP = Integer.MIN_VALUE;
        double tempPval2 = Double.NEGATIVE_INFINITY;
        int tempP2 = Integer.MIN_VALUE;
        DisposableIntIterator it = this.GNodes.inArcs[nid].getIterator();
        while (it.hasNext()) {
            double lpfs;
            int arcId = it.next();
            int orig = this.GArcs.origs[arcId];
            double spfs = this.GNodes.spfs.quickGet(orig) + this.GArcs.costs[arcId];
            if (tempPval > spfs) {
                tempPval = spfs;
                tempP = arcId;
            }
            if (!(tempPval2 < (lpfs = this.GNodes.lpfs.quickGet(orig) + this.GArcs.costs[arcId]))) continue;
            tempPval2 = lpfs;
            tempP2 = arcId;
        }
        it.dispose();
        double old = this.GNodes.spfs.quickSet(nid, tempPval);
        this.GNodes.prevSP.quickSet(nid, tempP);
        double old2 = this.GNodes.lpfs.quickSet(nid, tempPval2);
        this.GNodes.prevLP.quickSet(nid, tempP2);
        if (nid != this.tinkIndex && (old != tempPval || old2 != tempPval2)) {
            it = this.GNodes.outArcs[nid].getIterator();
            while (it.hasNext()) {
                int arcId = it.next();
                int dest = this.GArcs.dests[arcId];
                if (old != tempPval && this.GNodes.prevSP.quickGet(dest) == arcId || old2 != tempPval2 && this.GNodes.prevLP.quickGet(dest) == arcId) {
                    this.toUpdateLeft.push(dest);
                }
                double spft = this.GNodes.spft.quickGet(dest);
                double acost = this.GArcs.costs[arcId];
                double lpft = this.GNodes.lpft.quickGet(dest);
                if (!this.isNotInStack(arcId) || !(tempPval + spft + acost > (double)propagator.getVar(this.starts.length).getUB()) && !(tempPval2 + lpft + acost < (double)propagator.getVar(this.starts.length).getLB())) continue;
                this.setInStack(arcId);
                toRemove.push(arcId);
            }
            it.dispose();
        }
    }

    @Deprecated
    public void updateSPFS(int nid, TIntStack toRemove, Propagator<IntVar> propagator) {
        double tempPval = Double.POSITIVE_INFINITY;
        int tempP = Integer.MIN_VALUE;
        DisposableIntIterator it = this.GNodes.inArcs[nid].getIterator();
        while (it.hasNext()) {
            int arcId = it.next();
            int orig = this.GArcs.origs[arcId];
            double spfs = this.GNodes.spfs.quickGet(orig) + this.GArcs.costs[arcId];
            if (!(tempPval > spfs)) continue;
            tempPval = spfs;
            tempP = arcId;
        }
        it.dispose();
        double old = this.GNodes.spfs.quickSet(nid, tempPval);
        this.GNodes.prevSP.quickSet(nid, tempP);
        if (nid != this.tinkIndex && old != tempPval) {
            it = this.GNodes.outArcs[nid].getIterator();
            while (it.hasNext()) {
                int arcId = it.next();
                int dest = this.GArcs.dests[arcId];
                if (this.GNodes.prevSP.quickGet(dest) == arcId) {
                    this.updateSPFS(dest, toRemove, propagator);
                }
                double spft = this.GNodes.spft.quickGet(dest);
                double acost = this.GArcs.costs[arcId];
                if (!this.isNotInStack(arcId) || !(tempPval + spft + acost > (double)propagator.getVar(this.starts.length).getUB())) continue;
                this.setInStack(arcId);
                toRemove.push(arcId);
            }
            it.dispose();
        }
    }

    @Deprecated
    public void updateLPFS(int nid, TIntStack toRemove, Propagator<IntVar> propagator) {
        double tempPval = Double.NEGATIVE_INFINITY;
        int tempP = Integer.MIN_VALUE;
        DisposableIntIterator it = this.GNodes.inArcs[nid].getIterator();
        while (it.hasNext()) {
            int arcId = it.next();
            int orig = this.GArcs.origs[arcId];
            double lpfs = this.GNodes.lpfs.quickGet(orig) + this.GArcs.costs[arcId];
            if (!(tempPval < lpfs)) continue;
            tempPval = lpfs;
            tempP = arcId;
        }
        it.dispose();
        double old = this.GNodes.lpfs.quickSet(nid, tempPval);
        this.GNodes.prevLP.quickSet(nid, tempP);
        if (nid != this.tinkIndex && old != tempPval) {
            it = this.GNodes.outArcs[nid].getIterator();
            while (it.hasNext()) {
                int arcId = it.next();
                int dest = this.GArcs.dests[arcId];
                if (this.GNodes.prevLP.quickGet(dest) == arcId) {
                    this.updateLPFS(dest, toRemove, propagator);
                }
                double lpft = this.GNodes.lpft.quickGet(dest);
                double acost = this.GArcs.costs[arcId];
                if (!this.isNotInStack(arcId) || !(tempPval + lpft + acost < (double)propagator.getVar(this.starts.length).getLB())) continue;
                this.setInStack(arcId);
                toRemove.push(arcId);
            }
            it.dispose();
        }
    }

    public final boolean isNotInStack(int idx) {
        return !this.inStack.get(idx);
    }

    public final void setInStack(int idx) {
        this.inStack.set(idx);
    }

    public final void clearInStack(int idx) {
        this.inStack.clear(idx);
    }

    public class Arcs {
        public int[] values;
        public int[] dests;
        public int[] origs;
        public double[] costs;
    }

    public class Nodes {
        public int[] states;
        public int[] layers;
        public StoredIndexedBipartiteSetWithOffset[] outArcs;
        public StoredIndexedBipartiteSetWithOffset[] inArcs;
        public IStateIntVector nextSP;
        public IStateIntVector prevSP;
        public IStateIntVector nextLP;
        public IStateIntVector prevLP;
        public IStateDoubleVector spfs;
        public IStateDoubleVector spft;
        public IStateDoubleVector lpfs;
        public IStateDoubleVector lpft;
    }
}

