/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata.structure.costregular;

import org.chocosolver.memory.structure.IndexedObject;
import org.chocosolver.solver.constraints.nary.automata.structure.Node;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.DefaultWeightedEdge;

public class Arc
extends DefaultWeightedEdge
implements IndexedObject {
    public int id;
    public Node orig;
    public Node dest;
    public int value;
    public double cost;

    public Arc(Node orig, Node dest, int value, int id, double cost) {
        this.id = id;
        this.orig = orig;
        this.dest = dest;
        this.value = value;
        this.cost = cost;
    }

    public Arc(Node orig, Node dest, int value) {
        this(orig, dest, value, Integer.MIN_VALUE, Double.POSITIVE_INFINITY);
    }

    @Override
    public double getWeight() {
        return this.cost;
    }

    @Override
    public String toString() {
        return this.value + "";
    }

    public final void setId(int id) {
        this.id = id;
    }

    @Override
    public int getObjectIdx() {
        return this.orig.state;
    }

    @Override
    public Arc clone() {
        Arc arc = (Arc)super.clone();
        arc.id = this.id;
        try {
            arc.orig = this.orig.clone();
            arc.dest = this.dest.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        arc.value = this.value;
        arc.cost = this.cost;
        return arc;
    }

    public static class ArcFacroty
    implements EdgeFactory<Node, Arc> {
        @Override
        public Arc createEdge(Node node, Node node1) {
            return new Arc(node, node1, 0, 0, 0.0);
        }
    }
}

