/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.conditions;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.alldifferent.algo.AlgoAllDiffAC;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.Condition;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropCondAllDiff_AC
extends Propagator<IntVar> {
    private Condition condition;

    public PropCondAllDiff_AC(IntVar[] variables, Condition condition) {
        super((Variable[])variables, PropagatorPriority.QUADRATIC, false);
        this.condition = condition;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int nb = 0;
        for (IntVar v : (IntVar[])this.vars) {
            if (!this.condition.holdOnVar(v)) continue;
            ++nb;
        }
        IntVar[] vs = new IntVar[nb];
        for (IntVar v : (IntVar[])this.vars) {
            if (!this.condition.holdOnVar(v)) continue;
            vs[--nb] = v;
        }
        AlgoAllDiffAC filter = new AlgoAllDiffAC(vs, this);
        filter.propagate();
    }

    @Override
    public ESat isEntailed() {
        int nbInst = 0;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            ++nbInst;
            if (!this.condition.holdOnVar(((IntVar[])this.vars)[i])) continue;
            for (int j = i + 1; j < ((IntVar[])this.vars).length; ++j) {
                if (!this.condition.holdOnVar(((IntVar[])this.vars)[j]) || !((IntVar[])this.vars)[j].isInstantiated() || ((IntVar[])this.vars)[i].getValue() != ((IntVar[])this.vars)[j].getValue()) continue;
                return ESat.FALSE;
            }
        }
        if (nbInst == ((IntVar[])this.vars).length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

