/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.algo;

import java.util.Comparator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.sort.ArraySort;

public class AlgoAllDiffBC {
    private int[] t;
    private int[] d;
    private int[] h;
    private int[] bounds;
    private int nbBounds;
    private Interval[] intervals;
    private Interval[] minsorted;
    private Interval[] maxsorted;
    private Propagator aCause;
    private IntVar[] vars;
    private ArraySort<Interval> sorter;

    public AlgoAllDiffBC(Propagator cause) {
        this.aCause = cause;
    }

    public void reset(IntVar[] variables) {
        int i;
        this.vars = variables;
        int n = this.vars.length;
        if (this.intervals == null || this.intervals.length < n) {
            this.t = new int[2 * n + 2];
            this.d = new int[2 * n + 2];
            this.h = new int[2 * n + 2];
            this.bounds = new int[2 * n + 2];
            this.intervals = new Interval[n];
            this.minsorted = new Interval[n];
            this.maxsorted = new Interval[n];
            for (i = 0; i < n; ++i) {
                this.intervals[i] = new Interval();
            }
            this.sorter = new ArraySort(n, true, false);
        }
        for (i = 0; i < n; ++i) {
            Interval interval = this.intervals[i];
            interval.var = this.vars[i];
            this.minsorted[i] = interval;
            this.maxsorted[i] = interval;
        }
    }

    public void filter() throws ContradictionException {
        do {
            this.sortIt();
            boolean again = this.filterLower();
        } while (again |= this.filterUpper());
    }

    private void sortIt() {
        int n = this.vars.length;
        for (int i = 0; i < n; ++i) {
            IntVar vt = this.intervals[i].var;
            this.intervals[i].lb = vt.getLB();
            this.intervals[i].ub = vt.getUB();
        }
        this.sorter.sort((Interval[])this.minsorted, n, SORT.MIN);
        this.sorter.sort((Interval[])this.maxsorted, n, SORT.MAX);
        int min = this.minsorted[0].lb;
        int max = this.maxsorted[0].ub + 1;
        int last = min - 2;
        int nb = 0;
        this.bounds[0] = last;
        int i = 0;
        int j = 0;
        while (true) {
            if (i < this.vars.length && min <= max) {
                if (min != last) {
                    this.bounds[++nb] = last = min;
                }
                this.minsorted[i].minrank = nb;
                if (++i >= this.vars.length) continue;
                min = this.minsorted[i].lb;
                continue;
            }
            if (max != last) {
                this.bounds[++nb] = last = max;
            }
            this.maxsorted[j].maxrank = nb;
            if (++j == this.vars.length) break;
            max = this.maxsorted[j].ub + 1;
        }
        this.nbBounds = nb;
        this.bounds[nb + 1] = this.bounds[nb] + 2;
    }

    private void pathset(int[] tab, int start, int end, int to) {
        int next;
        int prev = next = start;
        while (prev != end) {
            next = tab[prev];
            tab[prev] = to;
            prev = next;
        }
    }

    private int pathmin(int[] tab, int i) {
        while (tab[i] < i) {
            i = tab[i];
        }
        return i;
    }

    private int pathmax(int[] tab, int i) {
        while (tab[i] > i) {
            i = tab[i];
        }
        return i;
    }

    private boolean filterLower() throws ContradictionException {
        int i;
        boolean filter = false;
        for (i = 1; i <= this.nbBounds + 1; ++i) {
            this.t[i] = this.h[i] = i - 1;
            this.d[i] = this.bounds[i] - this.bounds[i - 1];
        }
        for (i = 0; i < this.vars.length; ++i) {
            int x = this.maxsorted[i].minrank;
            int y = this.maxsorted[i].maxrank;
            int z = this.pathmax(this.t, x + 1);
            int j = this.t[z];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.t[z] = z + 1;
                z = this.pathmax(this.t, this.t[z]);
                this.t[z] = j;
            }
            this.pathset(this.t, x + 1, z, z);
            if (this.d[z] < this.bounds[z] - this.bounds[y]) {
                this.aCause.fails();
            }
            if (this.h[x] > x) {
                int w = this.pathmax(this.h, this.h[x]);
                if (this.maxsorted[i].var.updateLowerBound(this.bounds[w], this.aCause)) {
                    filter |= true;
                    this.maxsorted[i].lb = this.maxsorted[i].var.getLB();
                }
                this.pathset(this.h, x, w, w);
            }
            if (this.d[z] != this.bounds[z] - this.bounds[y]) continue;
            this.pathset(this.h, this.h[y], j - 1, y);
            this.h[y] = j - 1;
        }
        return filter;
    }

    private boolean filterUpper() throws ContradictionException {
        int i;
        boolean filter = false;
        for (i = 0; i <= this.nbBounds; ++i) {
            this.t[i] = this.h[i] = i + 1;
            this.d[i] = this.bounds[i + 1] - this.bounds[i];
        }
        for (i = this.vars.length - 1; i >= 0; --i) {
            int x = this.minsorted[i].maxrank;
            int y = this.minsorted[i].minrank;
            int z = this.pathmin(this.t, x - 1);
            int j = this.t[z];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.t[z] = z - 1;
                z = this.pathmin(this.t, this.t[z]);
                this.t[z] = j;
            }
            this.pathset(this.t, x - 1, z, z);
            if (this.d[z] < this.bounds[y] - this.bounds[z]) {
                this.aCause.fails();
            }
            if (this.h[x] < x) {
                int w = this.pathmin(this.h, this.h[x]);
                if (this.minsorted[i].var.updateUpperBound(this.bounds[w] - 1, this.aCause)) {
                    filter |= true;
                    this.minsorted[i].ub = this.minsorted[i].var.getUB();
                }
                this.pathset(this.h, x, w, w);
            }
            if (this.d[z] != this.bounds[y] - this.bounds[z]) continue;
            this.pathset(this.h, this.h[y], j + 1, y);
            this.h[y] = j + 1;
        }
        return filter;
    }

    private static class Interval {
        private int minrank;
        private int maxrank;
        private IntVar var;
        private int lb;
        private int ub;

        private Interval() {
        }
    }

    private static enum SORT implements Comparator<Interval>
    {
        MAX{

            @Override
            public final int compare(Interval o1, Interval o2) {
                return o1.ub - o2.ub;
            }
        }
        ,
        MIN{

            @Override
            public final int compare(Interval o1, Interval o2) {
                return o1.lb - o2.lb;
            }
        };

    }
}

