/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent;

import gnu.trove.stack.array.TIntArrayStack;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropAllDiffInst
extends Propagator<IntVar> {
    protected final int n;
    protected FastResetArrayStack toCheck = new FastResetArrayStack();

    public PropAllDiffInst(IntVar[] variables) {
        super((Variable[])variables, PropagatorPriority.UNARY, true);
        this.n = ((IntVar[])this.vars).length;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.toCheck.resetQuick();
        for (int v = 0; v < this.n; ++v) {
            if (!((IntVar[])this.vars)[v].isInstantiated()) continue;
            this.toCheck.push(v);
        }
        this.fixpoint();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.toCheck.resetQuick();
        this.toCheck.push(varIdx);
        this.fixpoint();
    }

    protected void fixpoint() throws ContradictionException {
        while (this.toCheck.size() > 0) {
            int vidx = this.toCheck.pop();
            int val = ((IntVar[])this.vars)[vidx].getValue();
            for (int i = 0; i < this.n; ++i) {
                if (i == vidx || !((IntVar[])this.vars)[i].removeValue(val, this) || !((IntVar[])this.vars)[i].isInstantiated()) continue;
                this.toCheck.push(i);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int nbInst = 0;
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            ++nbInst;
            for (int j = i + 1; j < this.n; ++j) {
                if (!((IntVar[])this.vars)[j].isInstantiatedTo(((IntVar[])this.vars)[i].getValue())) continue;
                return ESat.FALSE;
            }
        }
        if (nbInst == ((IntVar[])this.vars).length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        if (evt == IntEventType.INSTANTIATE) {
            assert (var.isBool()) : "BoolVar excepted";
            value = 1 - var.getValue();
        }
        if (evt == IntEventType.REMOVE) {
            int i = 0;
            for (int j = ((IntVar[])this.vars).length - 1; i <= j; ++i, --j) {
                if (((IntVar[])this.vars)[i] != var && ((IntVar[])this.vars)[i].isInstantiatedTo(value)) {
                    return newrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[i]);
                }
                if (((IntVar[])this.vars)[j] == var || !((IntVar[])this.vars)[j].isInstantiatedTo(value)) continue;
                return newrules |= ruleStore.addFullDomainRule(((IntVar[])this.vars)[j]);
            }
        } else {
            newrules |= super.why(ruleStore, var, evt, value);
        }
        return newrules;
    }

    protected static class FastResetArrayStack
    extends TIntArrayStack {
        protected FastResetArrayStack() {
        }

        public void resetQuick() {
            this._list.resetQuick();
        }
    }
}

