/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.tools.ArrayUtils;

public class PropKnapsack
extends Propagator<IntVar> {
    private int[] weigth;
    private int[] energy;
    private int[] order;
    private double[] ratio;
    private int n;
    private IntVar capacity;
    private IntVar power;

    public PropKnapsack(IntVar[] itemOccurence, IntVar capacity, IntVar power, int[] weight, int[] energy) {
        super((Variable[])ArrayUtils.append(itemOccurence, {capacity, power}), PropagatorPriority.LINEAR, false);
        this.weigth = weight;
        this.energy = energy;
        this.n = itemOccurence.length;
        this.capacity = ((IntVar[])this.vars)[this.n];
        this.power = ((IntVar[])this.vars)[this.n + 1];
        this.order = new int[this.n];
        this.ratio = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.ratio[i] = weight[i] == 0 ? Double.MAX_VALUE : (double)energy[i] / (double)weight[i];
        }
        this.order = ArrayUtils.array(0, this.n - 1);
        ArraySort sorter = new ArraySort(this.n, false, true);
        sorter.sort(this.order, this.n, (i1, i2) -> Double.compare(this.ratio[i2], this.ratio[i1]));
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int remainingCapacity = this.capacity.getUB();
        int maxPower = 0;
        for (int i = 0; i < this.n; ++i) {
            remainingCapacity -= this.weigth[i] * ((IntVar[])this.vars)[i].getLB();
            maxPower += this.energy[i] * ((IntVar[])this.vars)[i].getLB();
        }
        this.power.updateLowerBound(maxPower, this);
        if (remainingCapacity < 0) {
            this.fails();
        } else {
            for (int i = 0; i < this.n; ++i) {
                assert (remainingCapacity >= 0);
                int idx = this.order[i];
                if (((IntVar[])this.vars)[idx].getUB() - ((IntVar[])this.vars)[idx].getLB() <= 0) continue;
                int delta = this.weigth[idx] * (((IntVar[])this.vars)[idx].getUB() - ((IntVar[])this.vars)[idx].getLB());
                if (delta <= remainingCapacity) {
                    maxPower += this.energy[idx] * (((IntVar[])this.vars)[idx].getUB() - ((IntVar[])this.vars)[idx].getLB());
                    if ((remainingCapacity -= delta) != 0) continue;
                    this.power.updateUpperBound(maxPower, this);
                    return;
                }
                int deltaPow = (int)Math.ceil((double)remainingCapacity * this.ratio[idx]);
                this.power.updateUpperBound(maxPower + deltaPow, this);
                return;
            }
        }
    }

    @Override
    public ESat isEntailed() {
        double camax = this.capacity.getUB();
        double pomin = 0.0;
        for (int i = 0; i < this.n; ++i) {
            camax -= (double)(this.weigth[i] * ((IntVar[])this.vars)[i].getLB());
            pomin += (double)(this.energy[i] * ((IntVar[])this.vars)[i].getLB());
        }
        if (camax < 0.0 || pomin > (double)this.power.getUB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated() && pomin == (double)this.power.getValue()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        assert (var == this.power);
        if (IntEventType.isInclow(evt.getMask())) {
            for (int i = 0; i < this.n; ++i) {
                newrules |= ruleStore.addLowerBoundRule(((IntVar[])this.vars)[i]);
            }
        } else if (IntEventType.isDecupp(evt.getMask())) {
            for (int i = 0; i < this.n; ++i) {
                newrules |= ruleStore.addBoundsRule(((IntVar[])this.vars)[i]);
            }
            newrules |= ruleStore.addUpperBoundRule(((IntVar[])this.vars)[this.n]);
        } else {
            newrules |= super.why(ruleStore, var, evt, value);
        }
        return newrules;
    }
}

