/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropDiffN
extends Propagator<IntVar> {
    private int n;
    private UndirectedGraph overlappingBoxes;
    private ISet boxesToCompute;
    private boolean fast;

    public PropDiffN(IntVar[] x, IntVar[] y, IntVar[] dx, IntVar[] dy, boolean fast) {
        super((Variable[])ArrayUtils.append(x, y, dx, dy), PropagatorPriority.LINEAR, true);
        this.fast = fast;
        this.n = x.length;
        if (this.n != y.length || this.n != dx.length || this.n != dy.length) {
            throw new SolverException("PropDiffN variable arrays do not have same size");
        }
        this.overlappingBoxes = new UndirectedGraph(this.model, this.n, SetType.LINKED_LIST, true);
        this.boxesToCompute = SetFactory.makeStoredSet(SetType.LINKED_LIST, 0, this.model);
    }

    @Override
    public int getPropagationConditions(int idx) {
        if (this.fast) {
            return IntEventType.instantiation();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        int v = varIdx % this.n;
        ISetIterator iter = this.overlappingBoxes.getNeighOf(v).iterator();
        while (iter.hasNext()) {
            int i = iter.nextInt();
            if (this.mayOverlap(v, i)) continue;
            this.overlappingBoxes.removeEdge(v, i);
        }
        if (!this.boxesToCompute.contains(v)) {
            this.boxesToCompute.add(v);
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int i;
            for (i = 0; i < this.n; ++i) {
                this.overlappingBoxes.getNeighOf(i).clear();
            }
            for (i = 0; i < this.n; ++i) {
                for (int j = i + 1; j < this.n; ++j) {
                    if (!this.mayOverlap(i, j)) continue;
                    this.overlappingBoxes.addEdge(i, j);
                    if (!this.boxInstantiated(i) || !this.boxInstantiated(j)) continue;
                    this.fails();
                }
            }
            this.boxesToCompute.clear();
            for (i = 0; i < this.n; ++i) {
                this.boxesToCompute.add(i);
            }
        }
        ISetIterator iter = this.boxesToCompute.iterator();
        while (iter.hasNext()) {
            this.filterFromBox(iter.nextInt());
        }
        this.boxesToCompute.clear();
    }

    private boolean mayOverlap(int i, int j) {
        return this.isNotDisjoint(i, j, true) && this.isNotDisjoint(i, j, false);
    }

    private boolean isNotDisjoint(int i, int j, boolean horizontal) {
        int off = horizontal ? 0 : this.n;
        return ((IntVar[])this.vars)[i + off].getLB() < ((IntVar[])this.vars)[j + off].getUB() + ((IntVar[])this.vars)[j + off + 2 * this.n].getUB() && ((IntVar[])this.vars)[j + off].getLB() < ((IntVar[])this.vars)[i + off].getUB() + ((IntVar[])this.vars)[i + off + 2 * this.n].getUB();
    }

    protected void filterFromBox(int i) throws ContradictionException {
        int xm = ((IntVar[])this.vars)[i].getLB();
        int xM = ((IntVar[])this.vars)[i].getUB() + ((IntVar[])this.vars)[i + 2 * this.n].getUB();
        int ym = ((IntVar[])this.vars)[i + this.n].getLB();
        int yM = ((IntVar[])this.vars)[i + this.n].getUB() + ((IntVar[])this.vars)[i + 3 * this.n].getUB();
        int am = ((IntVar[])this.vars)[i + 2 * this.n].getLB() * ((IntVar[])this.vars)[i + 3 * this.n].getLB();
        ISetIterator iter = this.overlappingBoxes.getNeighOf(i).iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            xm = Math.min(xm, ((IntVar[])this.vars)[j].getLB());
            xM = Math.max(xM, ((IntVar[])this.vars)[j].getUB() + ((IntVar[])this.vars)[j + 2 * this.n].getUB());
            ym = Math.min(ym, ((IntVar[])this.vars)[j + this.n].getLB());
            yM = Math.max(yM, ((IntVar[])this.vars)[j + this.n].getUB() + ((IntVar[])this.vars)[j + 3 * this.n].getUB());
            if ((am += ((IntVar[])this.vars)[j + 2 * this.n].getLB() * ((IntVar[])this.vars)[j + 3 * this.n].getLB()) <= (xM - xm) * (yM - ym)) continue;
            this.fails();
        }
        boolean horizontal = true;
        boolean vertical = false;
        iter = this.overlappingBoxes.getNeighOf(i).iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            if (this.doOverlap(i, j, horizontal)) {
                this.filter(i, j, vertical);
            }
            if (this.doOverlap(i, j, vertical)) {
                this.filter(i, j, horizontal);
            }
            assert (!this.doOverlap(i, j, horizontal) || !this.doOverlap(i, j, vertical));
        }
    }

    private boolean doOverlap(int i, int j, boolean hori) {
        int offSet = hori ? 0 : this.n;
        int S_i = ((IntVar[])this.vars)[i + offSet].getUB();
        int e_i = ((IntVar[])this.vars)[i + offSet].getLB() + ((IntVar[])this.vars)[i + 2 * this.n + offSet].getLB();
        int S_j = ((IntVar[])this.vars)[j + offSet].getUB();
        int e_j = ((IntVar[])this.vars)[j + offSet].getLB() + ((IntVar[])this.vars)[j + 2 * this.n + offSet].getLB();
        return S_i < e_i && e_j > S_i && S_j < e_i || S_j < e_j && e_i > S_j && S_i < e_j;
    }

    private void filter(int i, int j, boolean hori) throws ContradictionException {
        int offSet = hori ? 0 : this.n;
        int S_i = ((IntVar[])this.vars)[i + offSet].getUB();
        int e_i = ((IntVar[])this.vars)[i + offSet].getLB() + ((IntVar[])this.vars)[i + 2 * this.n + offSet].getLB();
        int S_j = ((IntVar[])this.vars)[j + offSet].getUB();
        int e_j = ((IntVar[])this.vars)[j + offSet].getLB() + ((IntVar[])this.vars)[j + 2 * this.n + offSet].getLB();
        if (S_i < e_i || S_j < e_j) {
            if (e_j > S_i) {
                ((IntVar[])this.vars)[j + offSet].updateLowerBound(e_i, this);
                ((IntVar[])this.vars)[i + offSet].updateUpperBound(S_j - ((IntVar[])this.vars)[i + 2 * this.n + offSet].getLB(), this);
                ((IntVar[])this.vars)[i + offSet + 2 * this.n].updateUpperBound(S_j - ((IntVar[])this.vars)[i + offSet].getLB(), this);
            }
            if (S_j < e_i) {
                ((IntVar[])this.vars)[i + offSet].updateLowerBound(e_j, this);
                ((IntVar[])this.vars)[j + offSet].updateUpperBound(S_i - ((IntVar[])this.vars)[j + 2 * this.n + offSet].getLB(), this);
                ((IntVar[])this.vars)[j + offSet + 2 * this.n].updateUpperBound(S_i - ((IntVar[])this.vars)[j + offSet].getLB(), this);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            if (!this.boxInstantiated(i)) continue;
            for (int j = i + 1; j < this.n; ++j) {
                if (!this.boxInstantiated(j) || !this.mayOverlap(i, j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private boolean boxInstantiated(int i) {
        return ((IntVar[])this.vars)[i].isInstantiated() && ((IntVar[])this.vars)[i + this.n].isInstantiated() && ((IntVar[])this.vars)[i + 2 * this.n].isInstantiated() && ((IntVar[])this.vars)[i + 3 * this.n].isInstantiated();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("DIFFN(");
        sb.append("");
        for (int i = 0; i < this.n; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("[").append(((IntVar[])this.vars)[i].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 2 * this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 3 * this.n].toString()).append("]");
        }
        sb.append(")");
        return sb.toString();
    }
}

