/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.sort.IntComparator;

public class ValidityChecker
implements IntComparator {
    protected IntVar[] vars;
    public int[] sortedidx;
    protected int arity;
    protected ArraySort sorter;

    public ValidityChecker(int ari, IntVar[] vars) {
        this.arity = ari;
        this.vars = new IntVar[this.arity];
        this.sortedidx = new int[this.arity];
        this.sorter = new ArraySort(this.arity, false, true);
        for (int i = 0; i < vars.length; ++i) {
            this.vars[i] = vars[i];
            this.sortedidx[i] = i;
        }
    }

    public final int getPosition(int idx) {
        return idx;
    }

    public void sortvars() {
        for (int i = 0; i < this.arity; ++i) {
            this.sortedidx[i] = i;
        }
        this.sorter.sort(this.sortedidx, this.arity, this);
        boolean correct = true;
        for (int i = 0; i < this.vars.length - 1; ++i) {
            correct &= this.vars[this.sortedidx[i]].getDomainSize() <= this.vars[this.sortedidx[i + 1]].getDomainSize();
        }
        if (!correct) assert (false) : "wrong sort";
    }

    public boolean isValid(int[] tuple) {
        for (int i = 0; i < this.arity; ++i) {
            if (this.vars[this.sortedidx[i]].contains(tuple[this.sortedidx[i]])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(int i1, int i2) {
        return this.vars[i1].getDomainSize() - this.vars[i2].getDomainSize();
    }
}

