/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import java.util.BitSet;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;

public class TuplesTable
extends LargeRelation {
    private final int n;
    private final BitSet table;
    private final int[] lowerbounds;
    private final int[] upperbounds;
    private final boolean feasible;
    private final int[] blocks;

    public TuplesTable(Tuples tuples, IntVar[] vars) {
        this.n = vars.length;
        this.lowerbounds = new int[this.n];
        this.upperbounds = new int[this.n];
        this.feasible = tuples.isFeasible();
        int totalSize = 1;
        this.blocks = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.blocks[i] = totalSize;
            this.lowerbounds[i] = vars[i].getLB();
            this.upperbounds[i] = vars[i].getUB();
            totalSize *= this.upperbounds[i] - this.lowerbounds[i] + 1;
        }
        if (totalSize < 0 || totalSize / 8 > 0x3200000) {
            throw new SolverException("Tuples required over 50Mo of memory...");
        }
        this.table = new BitSet(totalSize);
        int nt = tuples.nbTuples();
        for (int i = 0; i < nt; ++i) {
            int[] tuple = tuples.get(i);
            if (!this.valid(tuple, vars)) continue;
            this.setTuple(tuple);
        }
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        int address = 0;
        for (int i = this.n - 1; i >= 0; --i) {
            if (tuple[i] < this.lowerbounds[i] || tuple[i] > this.upperbounds[i]) {
                return false;
            }
            address += (tuple[i] - this.lowerbounds[i]) * this.blocks[i];
        }
        return this.table.get(address);
    }

    @Override
    public boolean isConsistent(int[] tuple) {
        return this.checkTuple(tuple) == this.feasible;
    }

    private void setTuple(int[] tuple) {
        int address = 0;
        for (int i = this.n - 1; i >= 0; --i) {
            address += (tuple[i] - this.lowerbounds[i]) * this.blocks[i];
        }
        this.table.set(address);
    }
}

