/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropTableStr2
extends Propagator<IntVar> {
    private int[][] table;
    private str2_var[] str2vars;
    private ISet tuples;
    private ArrayList<str2_var> Ssup;
    private ArrayList<str2_var> Sval;
    private boolean firstProp = true;
    private Tuples tuplesObject;

    public PropTableStr2(IntVar[] vars_, Tuples tuplesObject) {
        super((Variable[])vars_, PropagatorPriority.LINEAR, false);
        this.table = tuplesObject.toMatrix();
        this.tuplesObject = tuplesObject;
        this.str2vars = new str2_var[this.table[0].length];
        for (int i = 0; i < this.table[0].length; ++i) {
            this.str2vars[i] = new str2_var(this.model.getEnvironment(), vars_[i], i, this.table);
        }
        this.tuples = SetFactory.makeStoredSet(SetType.BIPARTITESET, 0, this.model);
        this.Ssup = new ArrayList();
        this.Sval = new ArrayList();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.firstProp) {
            this.firstProp = false;
            this.model.getEnvironment().save(() -> {
                this.firstProp = true;
            });
            this.initialPropagate();
        }
        this.Filter();
    }

    @Override
    public ESat isEntailed() {
        if (this.firstProp) {
            return this.tuplesObject.check((IntVar[])this.vars);
        }
        boolean hasSupport = false;
        ISetIterator iSetIterator = this.tuples.iterator();
        while (iSetIterator.hasNext()) {
            int tuple = (Integer)iSetIterator.next();
            if (!this.is_tuple_supported(tuple)) continue;
            hasSupport = true;
        }
        if (hasSupport) {
            if (this.isCompletelyInstantiated()) {
                return ESat.TRUE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.FALSE;
    }

    @Override
    public String toString() {
        return "STR2 table constraint with " + this.table[0].length + "vars and " + this.table.length + "tuples";
    }

    private boolean is_tuple_supported(int tuple_index) {
        for (str2_var v : this.Sval) {
            if (v.var.contains(this.table[tuple_index][v.indice])) continue;
            return false;
        }
        return true;
    }

    private void initialPropagate() throws ContradictionException {
        for (str2_var vst : this.str2vars) {
            DisposableValueIterator vit = vst.var.getValueIterator(true);
            while (vit.hasNext()) {
                int value = vit.next();
                if (vst.index_map.containsKey(value)) continue;
                vst.var.removeValue(value, this);
            }
            vit.dispose();
        }
        for (int t = 0; t < this.table.length; ++t) {
            this.tuples.add(t);
        }
    }

    private void Filter() throws ContradictionException {
        this.Ssup.clear();
        this.Sval.clear();
        for (str2_var tmp : this.str2vars) {
            tmp.GAC_clear();
            this.Ssup.add(tmp);
            if (tmp.last_size.get() == tmp.var.getDomainSize()) continue;
            this.Sval.add(tmp);
            tmp.last_size.set(tmp.var.getDomainSize());
        }
        ISetIterator iSetIterator = this.tuples.iterator();
        while (iSetIterator.hasNext()) {
            int tuple = (Integer)iSetIterator.next();
            if (this.is_tuple_supported(tuple)) {
                for (int var = 0; var < this.Ssup.size(); ++var) {
                    str2_var v = this.Ssup.get(var);
                    if (v.isConsistant(this.table[tuple][v.indice])) continue;
                    v.makeConsistant(this.table[tuple][v.indice]);
                    if (v.nb_consistant != v.var.getDomainSize()) continue;
                    this.Ssup.set(var, this.Ssup.get(this.Ssup.size() - 1));
                    this.Ssup.remove(this.Ssup.size() - 1);
                    --var;
                }
                continue;
            }
            this.tuples.remove(tuple);
        }
        for (str2_var v : this.Ssup) {
            v.remove_unsupported_value(this);
        }
    }

    private class str2_var {
        private IntVar var;
        private int indice;
        private IStateInt last_size;
        private BitSet GAC_Val;
        private int nb_consistant;
        private TreeMap<Integer, Integer> index_map;

        private str2_var(IEnvironment env, IntVar var_, int indice_, int[][] table) {
            this.var = var_;
            this.last_size = env.makeInt(0);
            this.indice = indice_;
            this.nb_consistant = 0;
            this.index_map = new TreeMap();
            int key = 0;
            for (int[] t : table) {
                if (this.index_map.containsKey(t[this.indice])) continue;
                this.index_map.put(t[this.indice], key++);
            }
            this.GAC_Val = new BitSet(this.index_map.size());
        }

        private void GAC_clear() {
            this.GAC_Val.clear();
            this.nb_consistant = 0;
        }

        private boolean isConsistant(int value) {
            return this.GAC_Val.get(this.index_map.get(value));
        }

        private void makeConsistant(int value) {
            this.GAC_Val.set(this.index_map.get(value));
            ++this.nb_consistant;
        }

        private void remove_unsupported_value(ICause cause) throws ContradictionException {
            for (Map.Entry<Integer, Integer> e : this.index_map.entrySet()) {
                if (!this.var.contains(e.getKey()) || this.GAC_Val.get(e.getValue())) continue;
                this.var.removeValue(e.getKey(), cause);
            }
        }
    }
}

