/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.StoredSparseSet;
import org.chocosolver.util.objects.graphs.MultivaluedDecisionDiagram;

public class PropLargeMDDC
extends Propagator<IntVar> {
    private final TIntSet yes;
    private final TIntSet[] sets;
    private final StoredSparseSet no;
    private final MultivaluedDecisionDiagram MDD;
    private final int nvars;

    public PropLargeMDDC(MultivaluedDecisionDiagram MDD, IntVar ... VARS) {
        super((Variable[])VARS, PropagatorPriority.QUADRATIC, false);
        this.MDD = MDD;
        this.nvars = ((IntVar[])this.vars).length;
        this.yes = new TIntHashSet();
        this.no = new StoredSparseSet(VARS[0].getEnvironment());
        this.sets = new TIntHashSet[this.nvars];
        for (int i = 0; i < this.nvars; ++i) {
            this.sets[i] = new TIntHashSet(((IntVar[])this.vars)[i].getDomainSize());
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.mddc();
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int[] diag = this.MDD.getDiagram();
            int l = 0;
            int n = ((IntVar[])this.vars)[l].getValue() - this.MDD.getOffset(l);
            while (l < this.nvars - 1 && diag[n] > 0) {
                n = diag[n] + ((IntVar[])this.vars)[++l].getValue() - this.MDD.getOffset(l);
            }
            return ESat.eval(l == this.nvars - 1 && diag[n] == -1);
        }
        return ESat.UNDEFINED;
    }

    private void mddc() throws ContradictionException {
        int j;
        int o;
        int i;
        this.yes.clear();
        for (i = 0; i < this.nvars; ++i) {
            this.sets[i].clear();
            o = this.MDD.getOffset(i);
            int UB = ((IntVar[])this.vars)[i].getUB();
            j = ((IntVar[])this.vars)[i].getLB();
            while (j <= UB) {
                this.sets[i].add(j - o);
                j = ((IntVar[])this.vars)[i].nextValue(j);
            }
        }
        this.mddcSeekSupport(0, 0);
        for (i = 0; i < this.nvars; ++i) {
            o = this.MDD.getOffset(i);
            int[] values = this.sets[i].toArray();
            for (j = 0; j < values.length; ++j) {
                ((IntVar[])this.vars)[i].removeValue(values[j] + o, this);
            }
        }
    }

    private boolean mddcSeekSupport(int node, int layer) {
        if (this.yes.contains(node)) {
            return true;
        }
        if (this.no.contains(node)) {
            return false;
        }
        boolean res = false;
        int o = this.MDD.getOffset(layer);
        for (int i = 0; i < this.MDD.getNodeSize(layer); ++i) {
            int l2;
            int sG = this.MDD.getEdge(node + i);
            if (sG == 0 || !((IntVar[])this.vars)[layer].contains(i + o) || sG != -1 && !this.mddcSeekSupport(sG, layer + 1)) continue;
            res = true;
            this.sets[layer].remove(i);
            for (l2 = layer; l2 < this.nvars && this.sets[l2].isEmpty(); ++l2) {
            }
            if (l2 == this.nvars) break;
        }
        if (res) {
            this.yes.add(node);
        } else {
            this.no.add(node);
        }
        return res;
    }
}

